/*
 * Decompiled with CFR 0.152.
 */
package com.hytalelibrary.vote;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandManager;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.event.events.player.PlayerChatEvent;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class HytaleLibraryVotePlugin
extends JavaPlugin {
    private VoteConfig config;
    private VoteTask voteTask;

    public HytaleLibraryVotePlugin(JavaPluginInit javaPluginInit) {
        super(javaPluginInit);
    }

    public CompletableFuture<Void> preLoad() {
        System.out.println("========================================");
        System.out.println("  HytaleLibrary Vote Plugin v2.1");
        System.out.println("  Starting automatic vote checking...");
        System.out.println("========================================");
        this.config = new VoteConfig(this);
        this.config.load();
        this.voteTask = new VoteTask(this, this.config);
        this.voteTask.start();
        Executors.newSingleThreadScheduledExecutor().schedule(() -> {
            try {
                System.out.println("Vote Plugin: Attempting late event registration...");
                this.getEventRegistry().registerGlobal(PlayerChatEvent.class, this::onPlayerChat);
                System.out.println("Vote Plugin: Registered PlayerChatEvent listener successfully!");
            }
            catch (Exception exception) {
                System.err.println("Vote Plugin: Failed to register chat listener: " + exception.getMessage());
            }
        }, 10L, TimeUnit.SECONDS);
        System.out.println("Vote plugin enabled! Polling every " + this.config.getInterval() + " seconds.");
        return super.preLoad();
    }

    public void onPlayerChat(PlayerChatEvent playerChatEvent) {
        String string = playerChatEvent.getContent().trim();
        if (string.equalsIgnoreCase("/vote")) {
            playerChatEvent.setCancelled(true);
            try {
                playerChatEvent.getSender().sendMessage(Message.raw((String)"\u00a7e[Vote] \u00a7fVote for us at: \u00a7bhttps://hytalelibrary.com/server/your-server-link"));
                playerChatEvent.getSender().sendMessage(Message.raw((String)"\u00a7e[Vote] \u00a7fYou will receive a reward shortly after voting!"));
            }
            catch (Exception exception) {
                System.err.println("Error sending vote message: " + exception.getMessage());
            }
        }
    }

    public void onDisable() {
        if (this.voteTask != null) {
            this.voteTask.stop();
        }
        System.out.println("HytaleLibrary Vote Plugin disabled.");
    }

    private static class VoteConfig {
        private final HytaleLibraryVotePlugin plugin;
        private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
        private ConfigData data;
        private final Path configPath;

        public VoteConfig(HytaleLibraryVotePlugin hytaleLibraryVotePlugin) {
            this.plugin = hytaleLibraryVotePlugin;
            this.configPath = Paths.get("vote_plugin_config.json", new String[0]);
        }

        public void load() {
            try {
                if (!Files.exists(this.configPath, new LinkOption[0])) {
                    this.saveDefaultConfig();
                }
                try (BufferedReader bufferedReader = Files.newBufferedReader(this.configPath);){
                    this.data = (ConfigData)this.gson.fromJson((Reader)bufferedReader, ConfigData.class);
                }
            }
            catch (IOException iOException) {
                System.err.println("Failed to load config, using defaults.");
                this.data = new ConfigData();
            }
        }

        private void saveDefaultConfig() throws IOException {
            ConfigData configData = new ConfigData();
            configData.apiUrl = "https://www.hytalelibrary.com/api/vote.php";
            configData.serverKey = "93efa3bacc00044188367dc11631f29f6c16b69b1e8267c8f41867ddfda4ccb3";
            configData.checkIntervalSeconds = 30;
            configData.rewardCommands = Arrays.asList("give {player} wood_amber_branch_corner 1", "broadcast {player} just voted for the server! Thank you!");
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
                this.gson.toJson((Object)configData, (Appendable)bufferedWriter);
            }
        }

        public String getApiUrl() {
            return this.data.apiUrl;
        }

        public String getServerKey() {
            return this.data.serverKey;
        }

        public int getInterval() {
            return this.data.checkIntervalSeconds;
        }

        public List<String> getRewardCommands() {
            return this.data.rewardCommands;
        }

        private static class ConfigData {
            String apiUrl;
            String serverKey;
            int checkIntervalSeconds;
            List<String> rewardCommands;

            private ConfigData() {
            }
        }
    }

    private static class VoteTask {
        private final HytaleLibraryVotePlugin plugin;
        private final VoteConfig config;
        private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

        public VoteTask(HytaleLibraryVotePlugin hytaleLibraryVotePlugin, VoteConfig voteConfig) {
            this.plugin = hytaleLibraryVotePlugin;
            this.config = voteConfig;
        }

        public void start() {
            this.scheduler.scheduleAtFixedRate(this::poll, 10L, this.config.getInterval(), TimeUnit.SECONDS);
        }

        public void stop() {
            this.scheduler.shutdown();
        }

        private void poll() {
            try {
                VoteAPI voteAPI = new VoteAPI(this.config.getApiUrl(), this.config.getServerKey());
                List<VoteAPI.Vote> list = voteAPI.getPendingVotes();
                if (list.isEmpty()) {
                    return;
                }
                System.out.println("\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510");
                System.out.println("\u2502  Found " + list.size() + " new vote(s)!");
                System.out.println("\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518");
                ConsoleSender consoleSender = new ConsoleSender();
                HytaleServer hytaleServer = HytaleServer.get();
                CommandManager commandManager = hytaleServer.getCommandManager();
                for (VoteAPI.Vote vote : list) {
                    System.out.println("  -> Rewarding '" + vote.username + "'...");
                    for (String string : this.config.getRewardCommands()) {
                        String string2 = string.replace("{player}", vote.username);
                        try {
                            System.out.println("    Executing: " + string2);
                            commandManager.handleCommand((CommandSender)consoleSender, string2);
                            System.out.println("    Command dispatched.");
                        }
                        catch (Exception exception) {
                            System.err.println("Failed to execute command '" + string2 + "': " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
                voteAPI.acknowledgeVotes(list);
                System.out.println("\u2713 All votes acknowledged successfully!");
            }
            catch (Exception exception) {
                System.err.println("Failed to check votes: " + exception.getMessage());
            }
        }
    }

    private static class VoteAPI {
        private final String endpoint;
        private final String serverKey;
        private final Gson gson = new Gson();

        public VoteAPI(String string, String string2) {
            this.endpoint = string;
            this.serverKey = string2;
        }

        public List<Vote> getPendingVotes() throws Exception {
            URL uRL = new URL(this.endpoint + "?action=get&key=" + this.serverKey);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setReadTimeout(5000);
            if (httpURLConnection.getResponseCode() != 200) {
                throw new Exception("API returned status " + httpURLConnection.getResponseCode());
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                String string = bufferedReader.lines().collect(Collectors.joining("\n"));
                if (string == null || string.trim().isEmpty() || string.equals("[]")) {
                    ArrayList<Vote> arrayList = new ArrayList<Vote>();
                    return arrayList;
                }
                List list = (List)this.gson.fromJson(string, new TypeToken<List<Vote>>(this){
                    {
                        Objects.requireNonNull(voteAPI);
                    }
                }.getType());
                return list;
            }
        }

        public void acknowledgeVotes(List<Vote> list) throws Exception {
            if (list.isEmpty()) {
                return;
            }
            URL uRL = new URL(this.endpoint + "?action=ack&key=" + this.serverKey);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Vote object2 : list) {
                arrayList.add(object2.id);
            }
            String string = this.gson.toJson(arrayList);
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                outputStream.write(string.getBytes());
            }
            if (httpURLConnection.getResponseCode() != 200) {
                throw new Exception("Acknowledge failed with status " + httpURLConnection.getResponseCode());
            }
        }

        public static class Vote {
            public String id;
            public String username;
            public long timestamp;
        }
    }

    public static class ConsoleSender
    implements CommandSender {
        public String getDisplayName() {
            return "Console";
        }

        public UUID getUuid() {
            return UUID.fromString("00000000-0000-0000-0000-000000000000");
        }

        public void sendMessage(Message message) {
            System.out.println("[ConsoleSender] " + message.toString());
        }

        public boolean hasPermission(String string) {
            return true;
        }

        public boolean hasPermission(String string, boolean bl) {
            return true;
        }
    }
}

