/*
 * Decompiled with CFR 0.152.
 */
package com.hytalelibrary.essentials;

import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.player.PlayerChatEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerReadyEvent;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hytalelibrary.essentials.KitCommand;
import com.hytalelibrary.essentials.KitManager;
import com.hytalelibrary.essentials.PrefixCommand;
import com.hytalelibrary.essentials.PrefixManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class HyEssentialsPlugin
extends JavaPlugin {
    private KitManager kitManager;
    private KitCommand kitCommand;
    private PrefixManager prefixManager;
    private PrefixCommand prefixCommand;
    private World globalWorld;

    public HyEssentialsPlugin(JavaPluginInit javaPluginInit) {
        super(javaPluginInit);
    }

    public CompletableFuture<Void> preLoad() {
        System.out.println("[HyEssentials] Loading plugin...");
        File file = new File("mods/HyEssentials");
        if (!file.exists()) {
            file.mkdirs();
        }
        this.kitManager = new KitManager(file, this);
        this.kitCommand = new KitCommand(this.kitManager, this);
        this.prefixManager = new PrefixManager(file);
        this.prefixCommand = new PrefixCommand(this, this.prefixManager);
        return super.preLoad();
    }

    protected void start() {
        super.start();
        try {
            System.out.println("[HyEssentials] Registering commands...");
            HytaleServer.get().getCommandManager().register((AbstractCommand)this.kitCommand);
            HytaleServer.get().getCommandManager().register((AbstractCommand)this.prefixCommand);
            this.getEventRegistry().registerGlobal(PlayerReadyEvent.class, this::onPlayerReady);
            this.getEventRegistry().registerGlobal(PlayerChatEvent.class, this::onPlayerChat);
            System.out.println("[HyEssentials] Registered successfully!");
        }
        catch (Exception exception) {
            System.err.println("[HyEssentials] Failed to register: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void onPlayerReady(PlayerReadyEvent playerReadyEvent) {
        if (this.globalWorld == null && playerReadyEvent.getPlayer() != null) {
            this.globalWorld = playerReadyEvent.getPlayer().getWorld();
            System.out.println("[HyEssentials] Captured Global World reference.");
        }
    }

    public void shutdown() {
        if (this.kitManager != null) {
            this.kitManager.saveData();
        }
        super.shutdown();
    }

    public void onPlayerChat(PlayerChatEvent playerChatEvent) {
        try {
            PlayerRef playerRef = playerChatEvent.getSender();
            String string = playerRef.getUuid().toString();
            String string2 = this.prefixManager.getPrefix(string);
            if (string2 != null && !string2.isEmpty()) {
                playerChatEvent.setCancelled(true);
                String string3 = playerChatEvent.getContent().trim();
                String string4 = playerRef.getUsername();
                String string5 = string2 + " &f" + string4 + ": " + string3;
                Message message = this.parseLegacy(string5);
                if (this.globalWorld != null) {
                    List list = this.globalWorld.getPlayers();
                    for (Player player : list) {
                        player.sendMessage(message);
                    }
                } else {
                    System.out.println("[HyEssentials] WARN: Global World not captured, cannot broadcast chat cleanly.");
                }
                System.out.println("[Chat] " + string5.replace("\u00a7", "&"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Message parseLegacy(String string) {
        String[] stringArray;
        System.out.println("[Debug] Parsing Legacy: " + string);
        if (string == null || string.isEmpty()) {
            return Message.empty();
        }
        ArrayList<Message> arrayList = new ArrayList<Message>();
        String[] stringArray2 = stringArray = string.split("(?=[&\u00a7][0-9a-fk-or])");
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = string2 = stringArray2[i];
            char c = ' ';
            if (string2.length() >= 2 && (string2.charAt(0) == '&' || string2.charAt(0) == '\u00a7')) {
                c = string2.charAt(1);
                string3 = string2.substring(2);
            }
            if (string3.isEmpty()) continue;
            Message message = Message.raw((String)string3);
            String string4 = this.getHexForCode(c);
            if (string4 != null) {
                message = message.color(string4);
            }
            arrayList.add(message);
        }
        if (arrayList.isEmpty()) {
            return Message.empty();
        }
        return Message.join((Message[])arrayList.toArray(new Message[0]));
    }

    private String getHexForCode(char c) {
        switch (Character.toLowerCase(c)) {
            case '0': {
                return "#000000";
            }
            case '1': {
                return "#0000AA";
            }
            case '2': {
                return "#00AA00";
            }
            case '3': {
                return "#00AAAA";
            }
            case '4': {
                return "#AA0000";
            }
            case '5': {
                return "#AA00AA";
            }
            case '6': {
                return "#FFAA00";
            }
            case '7': {
                return "#AAAAAA";
            }
            case '8': {
                return "#555555";
            }
            case '9': {
                return "#5555FF";
            }
            case 'a': {
                return "#55FF55";
            }
            case 'b': {
                return "#55FFFF";
            }
            case 'c': {
                return "#FF5555";
            }
            case 'd': {
                return "#FF55FF";
            }
            case 'e': {
                return "#FFFF55";
            }
            case 'f': {
                return "#FFFFFF";
            }
            case 'r': {
                return "#FFFFFF";
            }
        }
        return null;
    }
}

