/*
 * Decompiled with CFR 0.152.
 */
package com.hytalelibrary.essentials;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hytalelibrary.essentials.HyEssentialsPlugin;
import com.hytalelibrary.essentials.KitManager;
import java.util.Arrays;
import java.util.List;

public class KitCommand
extends AbstractPlayerCommand {
    private final KitManager kitManager;
    private final HyEssentialsPlugin plugin;

    public KitCommand(KitManager kitManager, HyEssentialsPlugin hyEssentialsPlugin) {
        super("kit", "kits");
        this.kitManager = kitManager;
        this.plugin = hyEssentialsPlugin;
        this.setAllowsExtraArguments(true);
    }

    public void execute(CommandContext commandContext, Store<EntityStore> store, Ref<EntityStore> ref, PlayerRef playerRef, World world) {
        System.out.println("[KitCommand] Execute called for " + playerRef.getUsername());
        Player player = this.getPlayer(world, playerRef.getUsername());
        if (player == null) {
            System.err.println("[KitCommand] Failed to resolve player: " + playerRef.getUsername());
            return;
        }
        System.out.println("[KitCommand] Resolved player: " + player.getDisplayName());
        String string = commandContext.getInputString();
        Object[] objectArray = string.trim().split("\\s+");
        System.out.println("[KitCommand] Input: " + string + ", Args: " + Arrays.toString(objectArray));
        if (objectArray.length <= 1) {
            System.out.println("[KitCommand] Showing kit menu...");
            this.showKitMenu(player);
            return;
        }
        String string2 = ((String)objectArray[1]).toLowerCase();
        if (string2.equals("claim")) {
            if (objectArray.length < 3) {
                this.sendMessage(player, "&cUsage: /kit claim <name>");
                return;
            }
            Object object = objectArray[2];
            System.out.println("[KitCommand] Attempting to claim kit: " + (String)object);
            this.kitManager.handleClaim(player, (String)object);
        } else {
            this.sendMessage(player, "&cUnknown subcommand: " + string2);
        }
    }

    private Player getPlayer(World world, String string) {
        List list = world.getPlayers();
        for (Player player : list) {
            String string2 = player.getDisplayName();
            if (!string2.equalsIgnoreCase(string)) continue;
            return player;
        }
        return null;
    }

    private void showKitMenu(Player player) {
        this.sendMessage(player, "&6=== Kits ===");
        if (this.kitManager.getKits().isEmpty()) {
            this.sendMessage(player, "&cNo kits available.");
            return;
        }
        for (String string : this.kitManager.getKits()) {
            player.sendMessage(this.plugin.parseLegacy("&e- " + string + " (Type /kit claim " + string + ")"));
            Message message = Message.parse((String)("{\"text\":\"" + string + " \",\"color\":\"yellow\",\"extra\":[{\"text\":\"[Claim]\",\"color\":\"green\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/kit claim " + string + "\"}}]}"));
            player.sendMessage(message);
        }
    }

    private void sendMessage(PlayerRef playerRef, String string) {
        playerRef.sendMessage(this.plugin.parseLegacy(string));
    }

    private void sendMessage(Player player, String string) {
        player.sendMessage(this.plugin.parseLegacy(string));
    }
}

