/*
 * Decompiled with CFR 0.152.
 */
package com.hytalelibrary.essentials;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandManager;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hytalelibrary.essentials.HyEssentialsPlugin;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class KitManager {
    private final File dataFolder;
    private final File configFile;
    private final File claimedFile;
    private final Gson gson;
    private ConfigData config;
    private Map<String, Set<String>> claimedData;
    private final HyEssentialsPlugin plugin;

    public KitManager(File file, HyEssentialsPlugin hyEssentialsPlugin) {
        this.dataFolder = file;
        this.plugin = hyEssentialsPlugin;
        this.configFile = new File(file, "config.json");
        this.claimedFile = new File(file, "claimed.json");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.claimedData = new ConcurrentHashMap<String, Set<String>>();
        this.loadConfig();
        this.loadData();
    }

    public ConfigData getConfig() {
        return this.config;
    }

    public boolean hasClaimed(Player player, String string) {
        if (!this.claimedData.containsKey(string)) {
            return false;
        }
        String string2 = player.getUuid().toString();
        return this.claimedData.get(string).contains(string2);
    }

    public Set<String> getKits() {
        return this.config.kits.keySet();
    }

    public void handleClaim(Player player, String string) {
        if (!this.config.kits.containsKey(string)) {
            player.sendMessage(this.plugin.parseLegacy("&cKit not found: " + string));
            return;
        }
        if (this.hasClaimed(player, string)) {
            player.sendMessage(this.plugin.parseLegacy("&cYou have already claimed this kit!"));
            return;
        }
        if (this.claimKit(player, string)) {
            player.sendMessage(this.plugin.parseLegacy("&aSuccessfully claimed kit: " + string));
        } else {
            player.sendMessage(this.plugin.parseLegacy("&cError claiming kit (See console)."));
        }
    }

    public boolean claimKit(Player player, String string2) {
        if (!this.config.kits.containsKey(string2)) {
            return false;
        }
        if (this.hasClaimed(player, string2)) {
            return false;
        }
        Kit kit = this.config.kits.get(string2);
        CommandManager commandManager = HytaleServer.get().getCommandManager();
        ConsoleSenderProxy consoleSenderProxy = new ConsoleSenderProxy();
        for (String string3 : kit.commands) {
            String string4 = string3.replace("{player}", player.getDisplayName());
            try {
                commandManager.handleCommand((CommandSender)consoleSenderProxy, string4);
            }
            catch (Exception exception) {
                System.err.println("[HyEssentials] Failed to give kit item: " + string4);
                exception.printStackTrace();
            }
        }
        String string5 = player.getUuid().toString();
        this.claimedData.computeIfAbsent(string2, string -> new HashSet()).add(string5);
        this.saveData();
        return true;
    }

    private void loadConfig() {
        try {
            if (!this.configFile.exists()) {
                this.saveDefaultConfig();
            }
            try (FileReader fileReader = new FileReader(this.configFile);){
                this.config = (ConfigData)this.gson.fromJson((Reader)fileReader, ConfigData.class);
                System.out.println("[KitManager] Loaded " + this.config.kits.size() + " kits: " + String.valueOf(this.config.kits.keySet()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.config = new ConfigData();
        }
    }

    private void saveDefaultConfig() throws IOException {
        ConfigData configData = new ConfigData();
        configData.kits = new HashMap<String, Kit>();
        Kit kit = new Kit();
        kit.display_name = "Starter Kit";
        kit.commands = Arrays.asList("give {player} weapon_sword_wood --quantity=1", "give {player} tool_pickaxe_wood --quantity=1", "give {player} tool_hatchet_wood --quantity=1", "give {player} plant_fruit_apple --quantity=5");
        configData.kits.put("starter", kit);
        try (FileWriter fileWriter = new FileWriter(this.configFile);){
            this.gson.toJson((Object)configData, (Appendable)fileWriter);
        }
    }

    private void loadData() {
        block8: {
            try {
                if (!this.claimedFile.exists()) break block8;
                try (FileReader fileReader = new FileReader(this.claimedFile);){
                    Map map = (Map)this.gson.fromJson((Reader)fileReader, new TypeToken<Map<String, Set<String>>>(this){
                        {
                            Objects.requireNonNull(kitManager);
                        }
                    }.getType());
                    if (map != null) {
                        this.claimedData = map;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void saveData() {
        try (FileWriter fileWriter = new FileWriter(this.claimedFile);){
            this.gson.toJson(this.claimedData, (Appendable)fileWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class ConfigData {
        public Map<String, Kit> kits = new HashMap<String, Kit>();
    }

    public static class Kit {
        public String display_name;
        public List<String> commands = new ArrayList<String>();
    }

    public static class ConsoleSenderProxy
    implements CommandSender {
        public String getDisplayName() {
            return "Console";
        }

        public UUID getUuid() {
            return UUID.randomUUID();
        }

        public void sendMessage(Message message) {
        }

        public boolean hasPermission(String string) {
            return true;
        }

        public boolean hasPermission(String string, boolean bl) {
            return true;
        }
    }
}

