/*
 * Decompiled with CFR 0.152.
 */
package com.hytalelibrary.essentials;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hytalelibrary.essentials.HyEssentialsPlugin;
import com.hytalelibrary.essentials.PrefixManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PrefixCommand
extends AbstractPlayerCommand {
    private final PrefixManager prefixManager;
    private final HyEssentialsPlugin plugin;

    public PrefixCommand(HyEssentialsPlugin hyEssentialsPlugin, PrefixManager prefixManager) {
        super("prefix", "rank");
        this.plugin = hyEssentialsPlugin;
        this.prefixManager = prefixManager;
        this.setAllowsExtraArguments(true);
    }

    public void execute(CommandContext commandContext, Store<EntityStore> store, Ref<EntityStore> ref, PlayerRef playerRef, World world) {
        Player player = this.getPlayer(world, playerRef.getUsername());
        if (player == null) {
            return;
        }
        if (!player.hasPermission("hyessentials.prefix")) {
            this.sendMessage(player, "&cYou do not have permission to use this command.");
            return;
        }
        String string = commandContext.getInputString();
        System.out.println("[PrefixCommand] Full Input: " + string);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string.split("\\s+")));
        if (!arrayList.isEmpty() && (((String)arrayList.get(0)).equalsIgnoreCase("prefix") || ((String)arrayList.get(0)).equalsIgnoreCase("rank"))) {
            arrayList.remove(0);
        } else if (!arrayList.isEmpty() && ((String)arrayList.get(0)).startsWith("/")) {
            arrayList.remove(0);
        }
        arrayList.removeIf(String::isEmpty);
        if (arrayList.isEmpty()) {
            this.sendMessage(player, "&cUsage: /prefix add <player> <prefix> OR /prefix remove <player>");
            return;
        }
        String string2 = ((String)arrayList.get(0)).toLowerCase();
        if (string2.equals("add") || string2.equals("set")) {
            if (arrayList.size() < 3) {
                this.sendMessage(player, "&cUsage: /prefix add <player> <prefix>");
                return;
            }
            String string3 = (String)arrayList.get(1);
            String string4 = (String)arrayList.get(2);
            if (arrayList.size() > 3) {
                string4 = String.join((CharSequence)" ", arrayList.subList(2, arrayList.size()));
            }
            string4 = string4.replace("$", "&");
            Player player2 = this.getPlayer(world, string3);
            if (player2 == null) {
                this.sendMessage(player, "&cPlayer '" + string3 + "' not found.");
                return;
            }
            String string5 = player2.getUuid().toString();
            this.prefixManager.setPrefix(string5, string4);
            this.sendMessage(player, "&aSet prefix for " + string3 + " to: " + string4);
            return;
        }
        if (string2.equals("remove")) {
            if (arrayList.size() < 2) {
                this.sendMessage(player, "&cUsage: /prefix remove <player>");
                return;
            }
            String string6 = (String)arrayList.get(1);
            Player player3 = this.getPlayer(world, string6);
            if (player3 == null) {
                this.sendMessage(player, "&cPlayer '" + string6 + "' not found.");
                return;
            }
            String string7 = player3.getUuid().toString();
            this.prefixManager.removePrefix(string7);
            this.sendMessage(player, "&aRemoved prefix for " + string6);
            return;
        }
        this.sendMessage(player, "&cUnknown subcommand.");
    }

    private Player getPlayer(World world, String string) {
        List list = world.getPlayers();
        for (Player player : list) {
            if (!player.getDisplayName().equalsIgnoreCase(string)) continue;
            return player;
        }
        return null;
    }

    private void sendMessage(Player player, String string) {
        player.sendMessage(this.plugin.parseLegacy(string));
    }
}

