/*
 * Decompiled with CFR 0.152.
 */
package com.hytalelibrary.essentials;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class PrefixManager {
    private final File dataFolder;
    private final File prefixesFile;
    private final Gson gson;
    private Map<String, String> prefixes;

    public PrefixManager(File file) {
        this.dataFolder = file;
        this.prefixesFile = new File(file, "prefixes.json");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.prefixes = new ConcurrentHashMap<String, String>();
        this.loadPrefixes();
    }

    public void setPrefix(String string, String string2) {
        this.prefixes.put(string, string2);
        this.savePrefixes();
    }

    public String getPrefix(String string) {
        return this.prefixes.get(string);
    }

    public void removePrefix(String string) {
        this.prefixes.remove(string);
        this.savePrefixes();
    }

    private void loadPrefixes() {
        block8: {
            try {
                if (!this.prefixesFile.exists()) break block8;
                try (FileReader fileReader = new FileReader(this.prefixesFile);){
                    Map map = (Map)this.gson.fromJson((Reader)fileReader, new TypeToken<Map<String, String>>(this){
                        {
                            Objects.requireNonNull(prefixManager);
                        }
                    }.getType());
                    if (map != null) {
                        this.prefixes = map;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void savePrefixes() {
        try (FileWriter fileWriter = new FileWriter(this.prefixesFile);){
            this.gson.toJson(this.prefixes, (Appendable)fileWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

