/*
 * Decompiled with CFR 0.152.
 */
package dev.yamiru.hytatrade;

import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandManager;
import com.hypixel.hytale.server.core.event.events.player.PlayerDisconnectEvent;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.util.Config;
import dev.yamiru.hytatrade.commands.TradeAcceptCommand;
import dev.yamiru.hytatrade.commands.TradeAddCommand;
import dev.yamiru.hytatrade.commands.TradeCancelCommand;
import dev.yamiru.hytatrade.commands.TradeCommand;
import dev.yamiru.hytatrade.commands.TradeConfirmCommand;
import dev.yamiru.hytatrade.commands.TradeDenyCommand;
import dev.yamiru.hytatrade.commands.TradeHelpCommand;
import dev.yamiru.hytatrade.commands.TradeListCommand;
import dev.yamiru.hytatrade.commands.TradeRemoveCommand;
import dev.yamiru.hytatrade.config.HytaTradeConfig;
import dev.yamiru.hytatrade.manager.TradeManager;
import dev.yamiru.hytatrade.trade.Trade;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class HytaTradePlugin
extends JavaPlugin {
    private static HytaTradePlugin instance;
    private final Config<HytaTradeConfig> configHolder = this.withConfig(HytaTradeConfig.CODEC);
    private HytaTradeConfig config;
    private TradeManager tradeManager;
    private ScheduledFuture<?> cleanupTask;

    public HytaTradePlugin(@Nonnull JavaPluginInit init) {
        super(init);
        instance = this;
    }

    protected void setup() {
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("========================================");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("         HytaTrade v1.0.0              ");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("         Author: Yamiru                ");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("  https://github.com/yamiru/HytaTrade  ");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("========================================");
        this.config = (HytaTradeConfig)this.configHolder.get();
        this.configHolder.save();
        this.tradeManager = new TradeManager(this);
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("Configuration loaded successfully!");
    }

    protected void start() {
        this.registerCommands();
        this.registerEventListeners();
        this.startCleanupTask();
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("HytaTrade has been enabled!");
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("Use /tradehelp to see all commands");
    }

    protected void shutdown() {
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("Disabling HytaTrade...");
        if (this.tradeManager != null) {
            this.tradeManager.cancelAllTrades("Server is shutting down");
        }
        if (this.cleanupTask != null && !this.cleanupTask.isCancelled()) {
            this.cleanupTask.cancel(false);
        }
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("HytaTrade has been disabled!");
    }

    private void registerCommands() {
        CommandManager cmdManager = CommandManager.get();
        cmdManager.register((AbstractCommand)new TradeCommand(this));
        cmdManager.register((AbstractCommand)new TradeAcceptCommand(this));
        cmdManager.register((AbstractCommand)new TradeDenyCommand(this));
        cmdManager.register((AbstractCommand)new TradeAddCommand(this));
        cmdManager.register((AbstractCommand)new TradeRemoveCommand(this));
        cmdManager.register((AbstractCommand)new TradeListCommand(this));
        cmdManager.register((AbstractCommand)new TradeConfirmCommand(this));
        cmdManager.register((AbstractCommand)new TradeCancelCommand(this));
        cmdManager.register((AbstractCommand)new TradeHelpCommand());
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("Commands registered!");
    }

    private void registerEventListeners() {
        this.getEventRegistry().register(PlayerDisconnectEvent.class, event -> {
            PlayerRef player = event.getPlayerRef();
            if (player == null) {
                return;
            }
            Trade trade = this.tradeManager.getActiveTrade(player.getUuid());
            if (trade != null && trade.isActive()) {
                this.tradeManager.cancelTrade(player, "Player disconnected");
            }
            if (this.tradeManager.hasPendingRequest(player.getUuid())) {
                this.tradeManager.denyTradeRequest(player);
            }
        });
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("Event listeners registered!");
    }

    private void startCleanupTask() {
        this.cleanupTask = HytaleServer.SCHEDULED_EXECUTOR.scheduleAtFixedRate(() -> {
            if (this.tradeManager != null) {
                this.tradeManager.cleanupExpiredRequests();
            }
        }, 30L, 15L, TimeUnit.SECONDS);
    }

    public static HytaTradePlugin getInstance() {
        return instance;
    }

    public HytaTradeConfig getPluginConfig() {
        return this.config;
    }

    public TradeManager getTradeManager() {
        return this.tradeManager;
    }
}

