/*
 * Decompiled with CFR 0.152.
 */
package dev.yamiru.hytatrade.commands;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import dev.yamiru.hytatrade.HytaTradePlugin;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TradeAddCommand
extends AbstractCommand {
    private final HytaTradePlugin plugin;

    public TradeAddCommand(HytaTradePlugin plugin) {
        super("tradeadd", "Add item from hand to trade");
        this.plugin = plugin;
        this.addAliases(new String[]{"tadd"});
    }

    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        if (!context.isPlayer()) {
            context.sendMessage(Message.raw((String)"[HytaTrade] This command can only be used by players!"));
            return CompletableFuture.completedFuture(null);
        }
        UUID uuid = context.sender().getUuid();
        PlayerRef player = this.findPlayer(uuid);
        if (player == null) {
            context.sendMessage(Message.raw((String)"[HytaTrade] Player not found!"));
            return CompletableFuture.completedFuture(null);
        }
        this.plugin.getTradeManager().addItemToTrade(player);
        return CompletableFuture.completedFuture(null);
    }

    private PlayerRef findPlayer(UUID uuid) {
        for (PlayerRef p : Universe.get().getPlayers()) {
            if (!p.getUuid().equals(uuid)) continue;
            return p;
        }
        return null;
    }
}

