/*
 * Decompiled with CFR 0.152.
 */
package dev.yamiru.hytatrade.commands;

import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import dev.yamiru.hytatrade.HytaTradePlugin;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TradeCommand
extends AbstractCommand {
    private final HytaTradePlugin plugin;
    private final RequiredArg<String> playerArg;

    public TradeCommand(HytaTradePlugin plugin) {
        super("trade", "Send a trade request to a player");
        this.plugin = plugin;
        this.playerArg = this.withRequiredArg("player", "Player name", (ArgumentType)ArgTypes.STRING);
    }

    @Nullable
    protected CompletableFuture<Void> execute(@Nonnull CommandContext context) {
        if (!context.isPlayer()) {
            context.sendMessage(Message.raw((String)"[HytaTrade] This command can only be used by players!"));
            return CompletableFuture.completedFuture(null);
        }
        UUID uuid = context.sender().getUuid();
        PlayerRef player = this.findPlayerByUuid(uuid);
        if (player == null) {
            context.sendMessage(Message.raw((String)"[HytaTrade] Player not found!"));
            return CompletableFuture.completedFuture(null);
        }
        String targetName = (String)this.playerArg.get(context);
        PlayerRef target = this.findPlayerByName(targetName);
        if (target == null) {
            context.sendMessage(Message.raw((String)("[HytaTrade] Player '" + targetName + "' not found!")));
            return CompletableFuture.completedFuture(null);
        }
        this.plugin.getTradeManager().sendTradeRequest(player, target);
        return CompletableFuture.completedFuture(null);
    }

    private PlayerRef findPlayerByUuid(UUID uuid) {
        for (PlayerRef p : Universe.get().getPlayers()) {
            if (!p.getUuid().equals(uuid)) continue;
            return p;
        }
        return null;
    }

    private PlayerRef findPlayerByName(String name) {
        String lowerName = name.toLowerCase();
        for (PlayerRef p : Universe.get().getPlayers()) {
            if (!p.getUsername().toLowerCase().startsWith(lowerName)) continue;
            return p;
        }
        return null;
    }
}

