/*
 * Decompiled with CFR 0.152.
 */
package dev.yamiru.hytatrade.manager;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import dev.yamiru.hytatrade.HytaTradePlugin;
import dev.yamiru.hytatrade.config.HytaTradeConfig;
import dev.yamiru.hytatrade.trade.Trade;
import dev.yamiru.hytatrade.trade.TradeRequest;
import dev.yamiru.hytatrade.trade.TradeState;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class TradeManager {
    private final HytaTradePlugin plugin;
    private final HytaTradeConfig config;
    private final Map<UUID, Trade> activeTrades;
    private final Map<UUID, TradeRequest> pendingRequests;
    private final Map<UUID, Long> cooldowns;

    public TradeManager(HytaTradePlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getPluginConfig();
        this.activeTrades = new ConcurrentHashMap<UUID, Trade>();
        this.pendingRequests = new ConcurrentHashMap<UUID, TradeRequest>();
        this.cooldowns = new ConcurrentHashMap<UUID, Long>();
    }

    public boolean sendTradeRequest(PlayerRef sender, PlayerRef receiver) {
        UUID receiverUuid;
        UUID senderUuid = sender.getUuid();
        if (senderUuid.equals(receiverUuid = receiver.getUuid())) {
            this.sendMessage(sender, "[HytaTrade] You cannot trade with yourself!");
            return false;
        }
        if (this.isOnCooldown(senderUuid)) {
            long remainingSeconds = this.getRemainingCooldown(senderUuid);
            this.sendMessage(sender, "[HytaTrade] You must wait " + remainingSeconds + " seconds!");
            return false;
        }
        if (this.isInTrade(senderUuid)) {
            this.sendMessage(sender, "[HytaTrade] You are already in a trade!");
            return false;
        }
        if (this.isInTrade(receiverUuid)) {
            this.sendMessage(sender, "[HytaTrade] This player is already trading!");
            return false;
        }
        TradeRequest request = new TradeRequest(sender, receiver, this.config.getTradeRequestTimeout());
        this.pendingRequests.put(receiverUuid, request);
        this.sendMessage(sender, "[HytaTrade] Trade request sent to " + receiver.getUsername() + "!");
        this.sendMessage(receiver, "");
        this.sendMessage(receiver, "==========================================");
        this.sendMessage(receiver, "[HytaTrade] " + sender.getUsername() + " sent you a trade request!");
        this.sendMessage(receiver, "");
        this.sendMessage(receiver, "  /tradeaccept (ta) - Accept");
        this.sendMessage(receiver, "  /tradedeny (td) - Deny");
        this.sendMessage(receiver, "==========================================");
        ((HytaleLogger.Api)this.plugin.getLogger().atInfo()).log("Trade request: %s -> %s", (Object)sender.getUsername(), (Object)receiver.getUsername());
        return true;
    }

    public boolean acceptTradeRequest(PlayerRef receiver) {
        UUID receiverUuid = receiver.getUuid();
        TradeRequest request = this.pendingRequests.get(receiverUuid);
        if (request == null || !request.isPending()) {
            this.sendMessage(receiver, "[HytaTrade] You have no pending trade requests!");
            return false;
        }
        PlayerRef sender = request.getSender();
        if (!this.isPlayerOnline(sender.getUuid())) {
            this.sendMessage(receiver, "[HytaTrade] Player is no longer online!");
            this.pendingRequests.remove(receiverUuid);
            return false;
        }
        request.accept();
        this.pendingRequests.remove(receiverUuid);
        Trade trade = new Trade(sender, receiver);
        this.activeTrades.put(sender.getUuid(), trade);
        this.activeTrades.put(receiverUuid, trade);
        this.sendMessage(sender, "");
        this.sendMessage(sender, "==========================================");
        this.sendMessage(sender, "[HytaTrade] " + receiver.getUsername() + " accepted your request!");
        this.sendMessage(sender, "==========================================");
        this.sendMessage(receiver, "");
        this.sendMessage(receiver, "==========================================");
        this.sendMessage(receiver, "[HytaTrade] You accepted the request from " + sender.getUsername() + "!");
        this.sendMessage(receiver, "==========================================");
        this.sendTradeInstructions(sender);
        this.sendTradeInstructions(receiver);
        this.showTradeStatus(sender);
        this.showTradeStatus(receiver);
        ((HytaleLogger.Api)this.plugin.getLogger().atInfo()).log("Trade started: %s <-> %s", (Object)sender.getUsername(), (Object)receiver.getUsername());
        return true;
    }

    private void sendTradeInstructions(PlayerRef player) {
        this.sendMessage(player, "");
        this.sendMessage(player, "========== COMMANDS ==========");
        this.sendMessage(player, "/tradeadd (tadd) - Add item from hand");
        this.sendMessage(player, "/traderemove <n> (trem) - Remove item");
        this.sendMessage(player, "/tradelist (tlist) - Show trade status");
        this.sendMessage(player, "/tradeconfirm (tok) - Confirm trade");
        this.sendMessage(player, "/tradecancel - Cancel trade");
        this.sendMessage(player, "==============================");
    }

    public boolean denyTradeRequest(PlayerRef receiver) {
        UUID receiverUuid = receiver.getUuid();
        TradeRequest request = this.pendingRequests.get(receiverUuid);
        if (request == null || !request.isPending()) {
            this.sendMessage(receiver, "[HytaTrade] You have no pending trade requests!");
            return false;
        }
        request.deny();
        this.pendingRequests.remove(receiverUuid);
        PlayerRef sender = request.getSender();
        if (this.isPlayerOnline(sender.getUuid())) {
            this.sendMessage(sender, "[HytaTrade] " + receiver.getUsername() + " denied your trade request.");
        }
        this.sendMessage(receiver, "[HytaTrade] You denied the trade request.");
        return true;
    }

    public void addItemToTrade(PlayerRef player) {
        UUID playerUuid = player.getUuid();
        Trade trade = this.activeTrades.get(playerUuid);
        if (trade == null || !trade.isActive()) {
            this.sendMessage(player, "[HytaTrade] You have no active trade!");
            return;
        }
        World world = Universe.get().getDefaultWorld();
        world.execute(() -> this.addItemToTradeInternal(player, trade));
    }

    private void addItemToTradeInternal(PlayerRef player, Trade trade) {
        UUID playerUuid = player.getUuid();
        try {
            Ref ref = player.getReference();
            if (ref == null) {
                this.sendMessage(player, "[HytaTrade] Error: Reference is null!");
                return;
            }
            Store store = ref.getStore();
            if (store == null) {
                this.sendMessage(player, "[HytaTrade] Error: Store is null!");
                return;
            }
            Player playerComponent = (Player)store.getComponent(ref, Player.getComponentType());
            if (playerComponent == null) {
                this.sendMessage(player, "[HytaTrade] Error: Player component is null!");
                return;
            }
            Inventory inventory = playerComponent.getInventory();
            if (inventory == null) {
                this.sendMessage(player, "[HytaTrade] Error: Inventory is null!");
                return;
            }
            ItemStack itemInHand = inventory.getItemInHand();
            if (itemInHand == null || itemInHand.isEmpty()) {
                this.sendMessage(player, "[HytaTrade] You are not holding any item!");
                return;
            }
            boolean isInitiator = trade.getInitiator().getUuid().equals(playerUuid);
            int maxItems = this.config.getMaxItemsPerTrade();
            boolean added = isInitiator ? trade.addInitiatorItem(itemInHand, maxItems) : trade.addTargetItem(itemInHand, maxItems);
            if (added) {
                byte activeSlot = inventory.getActiveHotbarSlot();
                inventory.getHotbar().removeItemStackFromSlot((short)activeSlot);
                String itemName = this.getItemName(itemInHand);
                this.sendMessage(player, "[HytaTrade] Added: " + itemName + " x" + itemInHand.getQuantity());
                PlayerRef other = trade.getOtherParticipant(playerUuid);
                if (other != null) {
                    this.sendMessage(other, "[HytaTrade] " + player.getUsername() + " added: " + itemName + " x" + itemInHand.getQuantity());
                }
                trade.resetConfirmations();
            } else {
                this.sendMessage(player, "[HytaTrade] Cannot add more items! Max: " + maxItems);
            }
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.plugin.getLogger().atWarning()).log("Error adding item for %s: %s", (Object)player.getUsername(), (Object)e.getMessage());
            this.sendMessage(player, "[HytaTrade] Error: " + e.getClass().getSimpleName());
        }
    }

    public void removeItemFromTrade(PlayerRef player, int index) {
        UUID playerUuid = player.getUuid();
        Trade trade = this.activeTrades.get(playerUuid);
        if (trade == null || !trade.isActive()) {
            this.sendMessage(player, "[HytaTrade] You have no active trade!");
            return;
        }
        World world = Universe.get().getDefaultWorld();
        world.execute(() -> this.removeItemFromTradeInternal(player, trade, index));
    }

    private void removeItemFromTradeInternal(PlayerRef player, Trade trade, int index) {
        UUID playerUuid = player.getUuid();
        boolean isInitiator = trade.getInitiator().getUuid().equals(playerUuid);
        ItemStack removed = isInitiator ? trade.removeInitiatorItem(index) : trade.removeTargetItem(index);
        if (removed != null) {
            this.giveItemInternal(player, removed);
            String itemName = this.getItemName(removed);
            this.sendMessage(player, "[HytaTrade] Removed: " + itemName + " x" + removed.getQuantity());
            PlayerRef other = trade.getOtherParticipant(playerUuid);
            if (other != null) {
                this.sendMessage(other, "[HytaTrade] " + player.getUsername() + " removed an item.");
            }
            trade.resetConfirmations();
        } else {
            this.sendMessage(player, "[HytaTrade] Invalid index! Use /tradelist to see items.");
        }
    }

    public void showTradeStatus(PlayerRef player) {
        String itemName;
        ItemStack item;
        int i;
        UUID playerUuid = player.getUuid();
        Trade trade = this.activeTrades.get(playerUuid);
        if (trade == null || !trade.isActive()) {
            this.sendMessage(player, "[HytaTrade] You have no active trade!");
            return;
        }
        boolean isInitiator = trade.getInitiator().getUuid().equals(playerUuid);
        List<ItemStack> myItems = isInitiator ? trade.getInitiatorItems() : trade.getTargetItems();
        List<ItemStack> theirItems = isInitiator ? trade.getTargetItems() : trade.getInitiatorItems();
        boolean myConfirmed = isInitiator ? trade.isInitiatorConfirmed() : trade.isTargetConfirmed();
        boolean theirConfirmed = isInitiator ? trade.isTargetConfirmed() : trade.isInitiatorConfirmed();
        PlayerRef other = trade.getOtherParticipant(playerUuid);
        String otherName = other != null ? other.getUsername() : "???";
        this.sendMessage(player, "");
        this.sendMessage(player, "========== TRADE STATUS ==========");
        this.sendMessage(player, "Trading with: " + otherName);
        this.sendMessage(player, "");
        this.sendMessage(player, "--- YOUR OFFER ---");
        if (myItems.isEmpty()) {
            this.sendMessage(player, "  (empty)");
        } else {
            for (i = 0; i < myItems.size(); ++i) {
                item = myItems.get(i);
                itemName = this.getItemName(item);
                this.sendMessage(player, "  [" + i + "] " + itemName + " x" + item.getQuantity());
            }
        }
        this.sendMessage(player, "  Status: " + (myConfirmed ? "CONFIRMED" : "not confirmed"));
        this.sendMessage(player, "");
        this.sendMessage(player, "--- OFFER FROM " + otherName + " ---");
        if (theirItems.isEmpty()) {
            this.sendMessage(player, "  (empty)");
        } else {
            for (i = 0; i < theirItems.size(); ++i) {
                item = theirItems.get(i);
                itemName = this.getItemName(item);
                this.sendMessage(player, "  [" + i + "] " + itemName + " x" + item.getQuantity());
            }
        }
        this.sendMessage(player, "  Status: " + (theirConfirmed ? "CONFIRMED" : "waiting"));
        this.sendMessage(player, "==================================");
        if (!myConfirmed) {
            this.sendMessage(player, ">> /tradeconfirm to confirm");
        }
    }

    public void confirmTrade(PlayerRef player) {
        boolean alreadyConfirmed;
        UUID playerUuid = player.getUuid();
        Trade trade = this.activeTrades.get(playerUuid);
        if (trade == null || !trade.isActive()) {
            this.sendMessage(player, "[HytaTrade] You have no active trade!");
            return;
        }
        boolean isInitiator = trade.getInitiator().getUuid().equals(playerUuid);
        boolean bl = alreadyConfirmed = isInitiator ? trade.isInitiatorConfirmed() : trade.isTargetConfirmed();
        if (alreadyConfirmed) {
            this.sendMessage(player, "[HytaTrade] Already confirmed! Waiting for the other party.");
            return;
        }
        if (isInitiator) {
            trade.confirmInitiator();
        } else {
            trade.confirmTarget();
        }
        PlayerRef other = trade.getOtherParticipant(playerUuid);
        this.sendMessage(player, "[HytaTrade] *** YOU CONFIRMED THE TRADE! ***");
        if (other != null) {
            this.sendMessage(other, "[HytaTrade] *** " + player.getUsername() + " CONFIRMED! ***");
        }
        if (trade.areBothConfirmed()) {
            this.sendMessage(player, "[HytaTrade] Both confirmed - completing trade!");
            if (other != null) {
                this.sendMessage(other, "[HytaTrade] Both confirmed - completing trade!");
            }
            this.completeTrade(trade);
        } else {
            this.sendMessage(player, "[HytaTrade] Waiting for the other party...");
            if (other != null) {
                this.sendMessage(other, "[HytaTrade] Use /tradeconfirm (tok) or /tradelist");
            }
        }
    }

    public void cancelTrade(PlayerRef player, String reason) {
        UUID playerUuid = player.getUuid();
        Trade trade = this.activeTrades.get(playerUuid);
        if (trade == null) {
            return;
        }
        trade.cancel();
        World world = Universe.get().getDefaultWorld();
        world.execute(() -> this.returnItemsInternal(trade));
        this.activeTrades.remove(trade.getInitiator().getUuid());
        this.activeTrades.remove(trade.getTarget().getUuid());
        this.setCooldown(trade.getInitiator().getUuid());
        this.setCooldown(trade.getTarget().getUuid());
        this.sendMessage(trade.getInitiator(), "[HytaTrade] Trade cancelled: " + reason);
        this.sendMessage(trade.getTarget(), "[HytaTrade] Trade cancelled: " + reason);
        ((HytaleLogger.Api)this.plugin.getLogger().atInfo()).log("Trade cancelled: %s <-> %s", (Object)trade.getInitiator().getUsername(), (Object)trade.getTarget().getUsername());
    }

    public void completeTrade(Trade trade) {
        if (trade.getState() != TradeState.CONFIRMING || !trade.areBothConfirmed()) {
            return;
        }
        trade.complete();
        World world = Universe.get().getDefaultWorld();
        world.execute(() -> this.transferItemsInternal(trade));
        this.activeTrades.remove(trade.getInitiator().getUuid());
        this.activeTrades.remove(trade.getTarget().getUuid());
        this.setCooldown(trade.getInitiator().getUuid());
        this.setCooldown(trade.getTarget().getUuid());
        this.sendMessage(trade.getInitiator(), "");
        this.sendMessage(trade.getInitiator(), "==========================================");
        this.sendMessage(trade.getInitiator(), "[HytaTrade] *** TRADE COMPLETED! ***");
        this.sendMessage(trade.getInitiator(), "==========================================");
        this.sendMessage(trade.getTarget(), "");
        this.sendMessage(trade.getTarget(), "==========================================");
        this.sendMessage(trade.getTarget(), "[HytaTrade] *** TRADE COMPLETED! ***");
        this.sendMessage(trade.getTarget(), "==========================================");
        if (this.config.isLogTradesEnabled()) {
            ((HytaleLogger.Api)this.plugin.getLogger().atInfo()).log("Trade completed: %s <-> %s", (Object)trade.getInitiator().getUsername(), (Object)trade.getTarget().getUsername());
        }
    }

    public void cancelAllTrades(String reason) {
        HashSet<Trade> uniqueTrades = new HashSet<Trade>(this.activeTrades.values());
        for (Trade trade : uniqueTrades) {
            if (!trade.isActive()) continue;
            this.cancelTrade(trade.getInitiator(), reason);
        }
    }

    public void cleanupExpiredRequests() {
        Iterator<Map.Entry<UUID, TradeRequest>> iterator = this.pendingRequests.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, TradeRequest> entry = iterator.next();
            TradeRequest request = entry.getValue();
            if (!request.isExpired()) continue;
            iterator.remove();
            PlayerRef sender = request.getSender();
            PlayerRef receiver = request.getReceiver();
            if (this.isPlayerOnline(sender.getUuid())) {
                this.sendMessage(sender, "[HytaTrade] Trade request expired.");
            }
            if (!this.isPlayerOnline(receiver.getUuid())) continue;
            this.sendMessage(receiver, "[HytaTrade] Trade request expired.");
        }
    }

    private void transferItemsInternal(Trade trade) {
        for (ItemStack item : trade.getInitiatorItems()) {
            this.giveItemInternal(trade.getTarget(), item);
        }
        for (ItemStack item : trade.getTargetItems()) {
            this.giveItemInternal(trade.getInitiator(), item);
        }
    }

    private void returnItemsInternal(Trade trade) {
        for (ItemStack item : trade.getInitiatorItems()) {
            this.giveItemInternal(trade.getInitiator(), item);
        }
        for (ItemStack item : trade.getTargetItems()) {
            this.giveItemInternal(trade.getTarget(), item);
        }
    }

    private void giveItemInternal(PlayerRef player, ItemStack item) {
        if (player == null || item == null || item.isEmpty()) {
            return;
        }
        try {
            Ref ref = player.getReference();
            if (ref == null) {
                return;
            }
            Store store = ref.getStore();
            if (store == null) {
                return;
            }
            Player playerComponent = (Player)store.getComponent(ref, Player.getComponentType());
            if (playerComponent != null && playerComponent.getInventory() != null) {
                playerComponent.getInventory().getCombinedHotbarFirst().addItemStack(item);
            }
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.plugin.getLogger().atWarning()).log("Failed to give item to %s: %s", (Object)player.getUsername(), (Object)e.getMessage());
        }
    }

    private String getItemName(ItemStack item) {
        if (item == null) {
            return "Unknown";
        }
        String id = item.getItemId();
        if (id.contains(":")) {
            id = id.substring(id.indexOf(":") + 1);
        }
        return id;
    }

    private void sendMessage(PlayerRef player, String message) {
        if (player != null) {
            player.sendMessage(Message.raw((String)message));
        }
    }

    private boolean isPlayerOnline(UUID playerUuid) {
        for (PlayerRef p : Universe.get().getPlayers()) {
            if (!p.getUuid().equals(playerUuid)) continue;
            return true;
        }
        return false;
    }

    public boolean isInTrade(UUID playerUuid) {
        Trade trade = this.activeTrades.get(playerUuid);
        return trade != null && trade.isActive();
    }

    public Trade getActiveTrade(UUID playerUuid) {
        return this.activeTrades.get(playerUuid);
    }

    public boolean hasPendingRequest(UUID playerUuid) {
        TradeRequest request = this.pendingRequests.get(playerUuid);
        return request != null && request.isPending();
    }

    public TradeRequest getPendingRequest(UUID playerUuid) {
        return this.pendingRequests.get(playerUuid);
    }

    private void setCooldown(UUID playerUuid) {
        this.cooldowns.put(playerUuid, System.currentTimeMillis());
    }

    private boolean isOnCooldown(UUID playerUuid) {
        Long lastTrade = this.cooldowns.get(playerUuid);
        if (lastTrade == null) {
            return false;
        }
        long elapsed = (System.currentTimeMillis() - lastTrade) / 1000L;
        return elapsed < (long)this.config.getTradeCooldown();
    }

    private long getRemainingCooldown(UUID playerUuid) {
        Long lastTrade = this.cooldowns.get(playerUuid);
        if (lastTrade == null) {
            return 0L;
        }
        long elapsed = (System.currentTimeMillis() - lastTrade) / 1000L;
        return Math.max(0L, (long)this.config.getTradeCooldown() - elapsed);
    }
}

