/*
 * Decompiled with CFR 0.152.
 */
package dev.yamiru.hytatrade.trade;

import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import dev.yamiru.hytatrade.trade.TradeState;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Trade {
    private final UUID tradeId = UUID.randomUUID();
    private final PlayerRef initiator;
    private final PlayerRef target;
    private final long startTime;
    private final List<ItemStack> initiatorItems;
    private final List<ItemStack> targetItems;
    private TradeState state;
    private boolean initiatorConfirmed;
    private boolean targetConfirmed;
    private long lastActivityTime;

    public Trade(PlayerRef initiator, PlayerRef target) {
        this.initiator = initiator;
        this.target = target;
        this.lastActivityTime = this.startTime = System.currentTimeMillis();
        this.initiatorItems = new ArrayList<ItemStack>();
        this.targetItems = new ArrayList<ItemStack>();
        this.state = TradeState.OPEN;
        this.initiatorConfirmed = false;
        this.targetConfirmed = false;
    }

    public boolean addInitiatorItem(ItemStack item, int maxItems) {
        if (this.state != TradeState.OPEN || this.initiatorItems.size() >= maxItems) {
            return false;
        }
        this.initiatorItems.add(item);
        this.resetConfirmations();
        this.updateActivity();
        return true;
    }

    public boolean addTargetItem(ItemStack item, int maxItems) {
        if (this.state != TradeState.OPEN || this.targetItems.size() >= maxItems) {
            return false;
        }
        this.targetItems.add(item);
        this.resetConfirmations();
        this.updateActivity();
        return true;
    }

    public ItemStack removeInitiatorItem(int index) {
        if (this.state != TradeState.OPEN || index < 0 || index >= this.initiatorItems.size()) {
            return null;
        }
        this.resetConfirmations();
        this.updateActivity();
        return this.initiatorItems.remove(index);
    }

    public ItemStack removeTargetItem(int index) {
        if (this.state != TradeState.OPEN || index < 0 || index >= this.targetItems.size()) {
            return null;
        }
        this.resetConfirmations();
        this.updateActivity();
        return this.targetItems.remove(index);
    }

    public void confirmInitiator() {
        this.initiatorConfirmed = true;
        this.updateActivity();
        this.checkForCompletion();
    }

    public void confirmTarget() {
        this.targetConfirmed = true;
        this.updateActivity();
        this.checkForCompletion();
    }

    public void unconfirmInitiator() {
        this.initiatorConfirmed = false;
        this.updateActivity();
    }

    public void unconfirmTarget() {
        this.targetConfirmed = false;
        this.updateActivity();
    }

    public void resetConfirmations() {
        this.initiatorConfirmed = false;
        this.targetConfirmed = false;
        if (this.state == TradeState.CONFIRMING) {
            this.state = TradeState.OPEN;
        }
    }

    private void checkForCompletion() {
        if (this.initiatorConfirmed && this.targetConfirmed) {
            this.state = TradeState.CONFIRMING;
        }
    }

    public void complete() {
        this.state = TradeState.COMPLETED;
    }

    public void cancel() {
        this.state = TradeState.CANCELLED;
    }

    private void updateActivity() {
        this.lastActivityTime = System.currentTimeMillis();
    }

    public boolean isActive() {
        return this.state == TradeState.OPEN || this.state == TradeState.CONFIRMING;
    }

    public boolean isParticipant(UUID playerUuid) {
        return this.initiator.getUuid().equals(playerUuid) || this.target.getUuid().equals(playerUuid);
    }

    public PlayerRef getOtherParticipant(UUID playerUuid) {
        if (this.initiator.getUuid().equals(playerUuid)) {
            return this.target;
        }
        if (this.target.getUuid().equals(playerUuid)) {
            return this.initiator;
        }
        return null;
    }

    public List<ItemStack> getPlayerItems(UUID playerUuid) {
        if (this.initiator.getUuid().equals(playerUuid)) {
            return new ArrayList<ItemStack>(this.initiatorItems);
        }
        if (this.target.getUuid().equals(playerUuid)) {
            return new ArrayList<ItemStack>(this.targetItems);
        }
        return new ArrayList<ItemStack>();
    }

    public boolean hasConfirmed(UUID playerUuid) {
        if (this.initiator.getUuid().equals(playerUuid)) {
            return this.initiatorConfirmed;
        }
        if (this.target.getUuid().equals(playerUuid)) {
            return this.targetConfirmed;
        }
        return false;
    }

    public UUID getTradeId() {
        return this.tradeId;
    }

    public PlayerRef getInitiator() {
        return this.initiator;
    }

    public PlayerRef getTarget() {
        return this.target;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public List<ItemStack> getInitiatorItems() {
        return new ArrayList<ItemStack>(this.initiatorItems);
    }

    public List<ItemStack> getTargetItems() {
        return new ArrayList<ItemStack>(this.targetItems);
    }

    public TradeState getState() {
        return this.state;
    }

    public boolean isInitiatorConfirmed() {
        return this.initiatorConfirmed;
    }

    public boolean isTargetConfirmed() {
        return this.targetConfirmed;
    }

    public boolean areBothConfirmed() {
        return this.initiatorConfirmed && this.targetConfirmed;
    }
}

