/*
 * Decompiled with CFR 0.152.
 */
package dev.yamiru.hytatrade.trade;

import com.hypixel.hytale.server.core.universe.PlayerRef;
import java.util.UUID;

public class TradeRequest {
    private final UUID requestId = UUID.randomUUID();
    private final PlayerRef sender;
    private final PlayerRef receiver;
    private final long timestamp;
    private final int timeoutSeconds;
    private boolean accepted;
    private boolean denied;
    private boolean expired;

    public TradeRequest(PlayerRef sender, PlayerRef receiver, int timeoutSeconds) {
        this.sender = sender;
        this.receiver = receiver;
        this.timestamp = System.currentTimeMillis();
        this.timeoutSeconds = timeoutSeconds;
        this.accepted = false;
        this.denied = false;
        this.expired = false;
    }

    public boolean isExpired() {
        if (this.expired) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedSeconds = (currentTime - this.timestamp) / 1000L;
        if (elapsedSeconds >= (long)this.timeoutSeconds) {
            this.expired = true;
            return true;
        }
        return false;
    }

    public int getRemainingSeconds() {
        if (this.isExpired()) {
            return 0;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedSeconds = (currentTime - this.timestamp) / 1000L;
        return Math.max(0, this.timeoutSeconds - (int)elapsedSeconds);
    }

    public void accept() {
        this.accepted = true;
    }

    public void deny() {
        this.denied = true;
    }

    public boolean isPending() {
        return !this.accepted && !this.denied && !this.isExpired();
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public PlayerRef getSender() {
        return this.sender;
    }

    public PlayerRef getReceiver() {
        return this.receiver;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public boolean isDenied() {
        return this.denied;
    }
}

