/*
 * Decompiled with CFR 0.152.
 */
package com.hytalelibrary.optimizer;

import com.hytalelibrary.optimizer.HyOptimizerPlugin;
import com.hytalelibrary.optimizer.OptimizerConfig;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;

public class AutoOptimizer {
    private final HyOptimizerPlugin plugin;
    private final OptimizerConfig config;
    private Timer timer;

    public AutoOptimizer(HyOptimizerPlugin hyOptimizerPlugin, OptimizerConfig optimizerConfig) {
        this.plugin = hyOptimizerPlugin;
        this.config = optimizerConfig;
    }

    public void start() {
        this.stop();
        if (this.config.autoGcIntervalSeconds <= 0) {
            return;
        }
        this.timer = new Timer("HyOptimizer-GC", true);
        long l = (long)this.config.autoGcIntervalSeconds * 1000L;
        System.out.println("[HyOptimizer] Scheduled Auto-GC every " + this.config.autoGcIntervalSeconds + " seconds.");
        this.timer.scheduleAtFixedRate(new TimerTask(this){
            {
                Objects.requireNonNull(autoOptimizer);
            }

            @Override
            public void run() {
                try {
                    long l = Runtime.getRuntime().freeMemory();
                    System.gc();
                    long l2 = Runtime.getRuntime().freeMemory();
                    long l3 = l2 - l;
                    if (l3 > 0x100000L) {
                        System.out.println("[HyOptimizer] Auto-GC freed " + l3 / 1024L / 1024L + " MB.");
                    }
                }
                catch (Exception exception) {
                    System.err.println("[HyOptimizer] GC Task failed: " + exception.getMessage());
                }
            }
        }, l, l);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

