/*
 * Decompiled with CFR 0.152.
 */
package com.hytalelibrary.optimizer;

import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hytalelibrary.optimizer.AutoOptimizer;
import com.hytalelibrary.optimizer.LogFilter;
import com.hytalelibrary.optimizer.OptimizeCommand;
import com.hytalelibrary.optimizer.OptimizerConfig;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;

public class HyOptimizerPlugin
extends JavaPlugin {
    private OptimizerConfig config;
    private LogFilter logFilter;
    private AutoOptimizer autoOptimizer;

    public HyOptimizerPlugin(JavaPluginInit javaPluginInit) {
        super(javaPluginInit);
    }

    public CompletableFuture<Void> preLoad() {
        System.out.println("[HyOptimizer] Loading...");
        this.config = OptimizerConfig.load();
        this.logFilter = new LogFilter(this.config);
        Logger logger = Logger.getLogger("");
        logger.setFilter(this.logFilter);
        System.out.println("[HyOptimizer] Log Filter installed.");
        return super.preLoad();
    }

    protected void start() {
        super.start();
        HytaleServer.get().getCommandManager().register((AbstractCommand)new OptimizeCommand(this));
        this.autoOptimizer = new AutoOptimizer(this, this.config);
        this.autoOptimizer.start();
        System.out.println("[HyOptimizer] Enabled! Auto-GC set to " + this.config.autoGcIntervalSeconds + "s.");
    }

    public void shutdown() {
        if (this.autoOptimizer != null) {
            this.autoOptimizer.stop();
        }
        System.out.println("[HyOptimizer] Disabled.");
        super.shutdown();
    }

    public void reloadConfig() {
        this.config = OptimizerConfig.load();
        if (this.logFilter != null) {
            this.logFilter.reload(this.config);
        }
        if (this.autoOptimizer != null) {
            this.autoOptimizer.stop();
            this.autoOptimizer = new AutoOptimizer(this, this.config);
            this.autoOptimizer.start();
        }
    }
}

