/*
 * Decompiled with CFR 0.152.
 */
package com.hytalelibrary.optimizer;

import com.hytalelibrary.optimizer.OptimizerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;

public class LogFilter
implements Filter {
    private final List<Pattern> patterns = new ArrayList<Pattern>();

    public LogFilter(OptimizerConfig optimizerConfig) {
        this.reload(optimizerConfig);
    }

    public void reload(OptimizerConfig optimizerConfig) {
        this.patterns.clear();
        for (String string : optimizerConfig.blockedPatterns) {
            try {
                this.patterns.add(Pattern.compile(string, 2));
            }
            catch (Exception exception) {
                System.err.println("[HyOptimizer] Invalid regex pattern: " + string);
            }
        }
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        String string = logRecord.getMessage();
        if (string == null) {
            return true;
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(string).find()) continue;
            return false;
        }
        return true;
    }
}

