/*
 * Decompiled with CFR 0.152.
 */
package com.hytalelibrary.optimizer;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hytalelibrary.optimizer.HyOptimizerPlugin;
import java.util.List;

public class OptimizeCommand
extends AbstractPlayerCommand {
    private final HyOptimizerPlugin plugin;

    public OptimizeCommand(HyOptimizerPlugin hyOptimizerPlugin) {
        super("optimize", "sysopt");
        this.plugin = hyOptimizerPlugin;
    }

    public void execute(CommandContext commandContext, Store<EntityStore> store, Ref<EntityStore> ref, PlayerRef playerRef, World world) {
        Player player = this.getPlayer(world, playerRef.getUsername());
        if (player == null) {
            return;
        }
        String string = commandContext.getInputString();
        String[] stringArray = string.trim().split("\\s+");
        if (stringArray.length <= 1) {
            this.sendMessage(player, "Usage: /optimize <gc|reload>");
            return;
        }
        String string2 = stringArray[1].toLowerCase();
        if (string2.equals("gc")) {
            this.sendMessage(player, "[HyOptimizer] Forcing Garbage Collection...");
            long l = Runtime.getRuntime().freeMemory();
            System.gc();
            long l2 = Runtime.getRuntime().freeMemory();
            long l3 = l2 - l;
            this.sendMessage(player, "[HyOptimizer] GC Complete. Freed: " + l3 / 1024L / 1024L + " MB.");
        } else if (string2.equals("reload")) {
            this.plugin.reloadConfig();
            this.sendMessage(player, "[HyOptimizer] Configuration reloaded.");
        } else {
            this.sendMessage(player, "Unknown subcommand. Use: gc, reload");
        }
    }

    private Player getPlayer(World world, String string) {
        List list = world.getPlayers();
        for (Player player : list) {
            if (!player.getPlayerRef().getUsername().equalsIgnoreCase(string)) continue;
            return player;
        }
        return null;
    }

    private void sendMessage(Player player, String string) {
        player.sendMessage(Message.raw((String)string));
    }
}

