/*
 * Decompiled with CFR 0.152.
 */
package com.hytalelibrary.optimizer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class OptimizerConfig {
    private static final File CONFIG_FILE = new File("mods/HyOptimizer/config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public int autoGcIntervalSeconds = 10;
    public List<String> blockedPatterns = new ArrayList<String>();

    public OptimizerConfig() {
        this.blockedPatterns.add("missing or invalid manifest.json");
        this.blockedPatterns.add("Unused key\\(s\\) in");
        this.blockedPatterns.add("Duplicate export name");
        this.blockedPatterns.add("API returned status 403");
        this.blockedPatterns.add("\\[removal\\] .* has been deprecated");
        this.blockedPatterns.add("Reloading nonexistent role null");
        this.blockedPatterns.add("Failed to make entity invisible");
        this.blockedPatterns.add("Asset key .* has incorrect format");
        this.blockedPatterns.add("Failed to validate asset");
        this.blockedPatterns.add("Attempted to store sync data");
        this.blockedPatterns.add("Took too long to .* process chunk");
        this.blockedPatterns.add("Took too long to run pre-load process");
        this.blockedPatterns.add("Animation .* does not exist");
        this.blockedPatterns.add("Could not parse default argument value");
        this.blockedPatterns.add("InteractionChain");
    }

    public static OptimizerConfig load() {
        OptimizerConfig optimizerConfig;
        if (!CONFIG_FILE.exists()) {
            OptimizerConfig optimizerConfig2 = new OptimizerConfig();
            optimizerConfig2.save();
            return optimizerConfig2;
        }
        FileReader fileReader = new FileReader(CONFIG_FILE);
        try {
            optimizerConfig = (OptimizerConfig)GSON.fromJson((Reader)fileReader, OptimizerConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)fileReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return new OptimizerConfig();
            }
        }
        ((Reader)fileReader).close();
        return optimizerConfig;
    }

    public void save() {
        try {
            if (!CONFIG_FILE.getParentFile().exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
            }
            try (FileWriter fileWriter = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)fileWriter);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

