/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.config;

import ch.serverrocket.config.ConfigManager;
import ch.serverrocket.main.Main;
import com.hypixel.hytale.logger.HytaleLogger;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;

public class ConfigService {
    private static final HytaleLogger LOGGER = HytaleLogger.forEnclosingClass();
    private final File configDir = new File(Main.getInstance().getDataDirectory().toFile(), "config");
    private final ConfigManager configManager = new ConfigManager();
    private final Map<Class<?>, Object> configs = new HashMap();

    public ConfigService(Main plugin) {
        this.configDir.mkdirs();
    }

    public <T> void load(String fileName, Class<T> type) {
        try {
            File file = new File(this.configDir, fileName);
            if (!file.exists()) {
                this.copyDefault(fileName, file);
            }
            T config = this.configManager.load(file, type);
            this.configs.put(type, config);
        }
        catch (Exception e) {
            ((HytaleLogger.Api)LOGGER.atSevere()).log("Failed to load config " + fileName, (Object)e);
        }
    }

    public <T> T get(Class<T> type) {
        return (T)this.configs.get(type);
    }

    private void copyDefault(String fileName, File target) throws Exception {
        try (InputStream in = this.getClass().getResourceAsStream("/config/" + fileName);){
            if (in == null) {
                throw new IllegalStateException("Resource /config/" + fileName + " not found");
            }
            Files.copy(in, target.toPath(), new CopyOption[0]);
        }
    }
}

