/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.config;

import ch.serverrocket.config.ConfigService;
import ch.serverrocket.config.configfiles.EconomyConfig;
import ch.serverrocket.config.configfiles.FriendsystemConfig;
import ch.serverrocket.config.configfiles.MinervaConfig;
import ch.serverrocket.config.configfiles.ModulesConfig;
import ch.serverrocket.config.configfiles.ServerRocketConfig;
import ch.serverrocket.config.configfiles.StockMarketConfig;

public final class Configs {
    private static ConfigService service;

    private Configs() {
    }

    public static void init(ConfigService configService) {
        service = configService;
    }

    public static MinervaConfig minerva() {
        Configs.checkInitialized();
        return service.get(MinervaConfig.class);
    }

    public static EconomyConfig economy() {
        Configs.checkInitialized();
        return service.get(EconomyConfig.class);
    }

    public static StockMarketConfig stockmarket() {
        Configs.checkInitialized();
        return service.get(StockMarketConfig.class);
    }

    public static FriendsystemConfig friendsystem() {
        Configs.checkInitialized();
        return service.get(FriendsystemConfig.class);
    }

    public static ServerRocketConfig serverrocket() {
        Configs.checkInitialized();
        return service.get(ServerRocketConfig.class);
    }

    public static ModulesConfig modules() {
        Configs.checkInitialized();
        return service.get(ModulesConfig.class);
    }

    private static void checkInitialized() {
        if (service == null) {
            throw new IllegalStateException("Configs not initialized! Call Configs.init(ConfigService) first.");
        }
    }
}

