/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.dashboard;

import ch.serverrocket.config.Configs;
import ch.serverrocket.dashboard.DashboardPageEventData;
import ch.serverrocket.dashboard.FriendRequestsPage;
import ch.serverrocket.database.economy.EconomyDataService;
import ch.serverrocket.database.economy.TransactionData;
import ch.serverrocket.database.friends.FriendDataService;
import ch.serverrocket.database.friends.Friendship;
import ch.serverrocket.database.player.PlayerData;
import ch.serverrocket.database.player.PlayerDataService;
import ch.serverrocket.database.stockmarket.PlayerStockData;
import ch.serverrocket.database.stockmarket.StockData;
import ch.serverrocket.database.stockmarket.StockDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import ch.serverrocket.utility.TeleportService;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DashboardPage
extends InteractiveCustomUIPage<DashboardPageEventData> {
    public static final String LAYOUT = "Minerva/PlayerDashboard.ui";
    private final PlayerRef playerRef;
    private String currentTab = "friends";
    private String currentSubTab = "bank";
    private String selectedFriendUuid;

    public DashboardPage(PlayerRef playerRef) {
        super(playerRef, CustomPageLifetime.CanDismiss, DashboardPageEventData.CODEC);
        this.playerRef = playerRef;
    }

    public void build(Ref<EntityStore> ref, UICommandBuilder builder, UIEventBuilder eventBuilder, Store<EntityStore> store) {
        builder.append(LAYOUT);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TabFriends", new EventData().append("Action", "switch_tab").append("Tab", "friends"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TabBank", new EventData().append("Action", "switch_tab").append("Tab", "bank"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#OpenFriendRequests", new EventData().append("Action", "open_friend_requests"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#BankSubTab", new EventData().append("Action", "switch_subtab").append("SubTab", "bank"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#MarketSubTab", new EventData().append("Action", "switch_subtab").append("SubTab", "market"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#PortfolioSubTab", new EventData().append("Action", "switch_subtab").append("SubTab", "portfolio"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#MyStockSubTab", new EventData().append("Action", "switch_subtab").append("SubTab", "mystock"), false);
        boolean stocksEnabled = false;
        try {
            stocksEnabled = Configs.modules().stockmarketIsActivated();
        }
        catch (Exception exception) {
            // empty catch block
        }
        builder.set("#BankSubNav.Visible", stocksEnabled);
        builder.set("#BankSubNavSpace.Visible", stocksEnabled);
        builder.set("#DashboardFriendsList.Visible", false);
        builder.set("#FriendsActions.Visible", false);
        builder.set("#FriendEntryActions.Visible", false);
        builder.set("#DashboardBankContainer.Visible", false);
        if (this.currentTab.equals("friends")) {
            builder.set("#DashboardFriendsList.Visible", true);
            builder.set("#FriendsActions.Visible", true);
            this.buildFriends(builder, eventBuilder);
        } else if (this.currentTab.equals("bank")) {
            builder.set("#DashboardBankContainer.Visible", true);
            this.buildBankModule(builder, eventBuilder, stocksEnabled);
        }
    }

    private void buildBankModule(UICommandBuilder builder, UIEventBuilder eventBuilder, boolean stocksEnabled) {
        BigDecimal balance = EconomyDataService.getBalance(this.playerRef.getUuid());
        builder.set("#BankBalanceText.Text", String.format(Langs.minerva().dashboardBankBalance(), balance.doubleValue()));
        builder.set("#BankContent.Visible", false);
        builder.set("#MarketContent.Visible", false);
        builder.set("#PortfolioContent.Visible", false);
        builder.set("#MyStockContent.Visible", false);
        if (stocksEnabled && !this.currentSubTab.equals("bank")) {
            if (this.currentSubTab.equals("market")) {
                builder.set("#MarketContent.Visible", true);
                this.buildMarket(builder, eventBuilder);
            } else if (this.currentSubTab.equals("portfolio")) {
                builder.set("#PortfolioContent.Visible", true);
                this.buildPortfolio(builder, eventBuilder);
            } else if (this.currentSubTab.equals("mystock")) {
                builder.set("#MyStockContent.Visible", true);
                this.buildMyStock(builder, eventBuilder);
            }
        } else {
            builder.set("#BankContent.Visible", true);
            this.buildBank(builder, eventBuilder);
        }
    }

    private void buildBank(UICommandBuilder builder, UIEventBuilder eventBuilder) {
        builder.clear("#BankTransactionList");
        List<TransactionData> history = EconomyDataService.getHistory(this.playerRef.getUuid());
        if (history.isEmpty()) {
            builder.append("#BankTransactionList", "Minerva/ReportEntry.ui");
            builder.set("#BankTransactionList[0].Text", Langs.minerva().dashboardBankNoTransactions());
        } else {
            for (int i = 0; i < Math.min(history.size(), 10); ++i) {
                TransactionData tx = history.get(i);
                String text = String.format(Langs.minerva().dashboardBankTransactionEntry(), tx.getType(), tx.getSender() != null && tx.getSender().equals(this.playerRef.getUuid()) ? "-" : "+", tx.getAmount().doubleValue(), tx.getDescription());
                String selector = "#BankTransactionList[" + i + "]";
                builder.append("#BankTransactionList", "Minerva/ReportEntry.ui");
                builder.set(selector + ".Text", text);
            }
        }
    }

    private void buildFriends(UICommandBuilder builder, UIEventBuilder eventBuilder) {
        builder.clear("#DashboardFriendsList");
        List<Friendship> friends = FriendDataService.getFriends(this.playerRef.getUuid());
        int index = 0;
        if (friends.isEmpty()) {
            builder.append("#DashboardFriendsList", "Minerva/ReportEntry.ui");
            builder.set("#DashboardFriendsList[" + index + "].Text", Langs.minerva().friendListEmpty());
        } else {
            boolean selectedStillFriend = false;
            for (Friendship friend : friends) {
                UUID friendUuid = friend.getFriendOf(this.playerRef.getUuid());
                PlayerData data = PlayerDataService.getByUUID(friendUuid);
                String name = data != null ? data.getDisplayName() : friendUuid.toString();
                String selector = "#DashboardFriendsList[" + index + "]";
                builder.append("#DashboardFriendsList", "Minerva/ReportEntry.ui");
                builder.set(selector + ".Text", name);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector, new EventData().append("Action", "select_friend").append("TargetUuid", friendUuid.toString()), false);
                ++index;
                if (!friendUuid.toString().equals(this.selectedFriendUuid)) continue;
                selectedStillFriend = true;
            }
            if (!selectedStillFriend) {
                this.selectedFriendUuid = null;
            }
            if (this.selectedFriendUuid != null) {
                PlayerData selected = PlayerDataService.getByUUID(UUID.fromString(this.selectedFriendUuid));
                String selectedName = selected != null ? selected.getDisplayName() : this.selectedFriendUuid;
                builder.set("#FriendSelectedLabel.Text", String.format(Langs.minerva().friendSelected(), selectedName));
                builder.set("#FriendEntryActions.Visible", true);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#FriendRemoveButton", new EventData().append("Action", "remove_friend").append("TargetUuid", this.selectedFriendUuid), false);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#FriendBlockButton", new EventData().append("Action", "block_friend").append("TargetUuid", this.selectedFriendUuid), false);
                boolean canTeleport = false;
                try {
                    canTeleport = Configs.friendsystem().isAllowTeleportToFriends();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                builder.set("#FriendTeleportButton.Visible", canTeleport);
                if (canTeleport) {
                    eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#FriendTeleportButton", new EventData().append("Action", "teleport_friend").append("TargetUuid", this.selectedFriendUuid), false);
                }
            }
        }
    }

    public void handleDataEvent(Ref<EntityStore> ref, Store<EntityStore> store, DashboardPageEventData data) {
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player != null) {
            if ("switch_tab".equals(data.action)) {
                this.currentTab = data.tab;
                if ("bank".equals(data.tab)) {
                    this.currentSubTab = "bank";
                }
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if ("open_friend_requests".equals(data.action)) {
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new FriendRequestsPage(this.playerRef));
            } else if ("select_friend".equals(data.action) && data.targetUuid != null) {
                this.selectedFriendUuid = data.targetUuid;
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if ("remove_friend".equals(data.action) && data.targetUuid != null) {
                UUID targetUuid = UUID.fromString(data.targetUuid);
                FriendDataService.removeFriend(this.playerRef.getUuid(), targetUuid);
                PlayerData targetData = PlayerDataService.getByUUID(targetUuid);
                String name = targetData != null ? targetData.getDisplayName() : data.targetUuid;
                String var19 = PrefixManager.friendsystem();
                player.sendMessage(Message.raw((String)(var19 + String.format(Langs.minerva().friendRemoved(), name))));
                this.selectedFriendUuid = null;
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if ("block_friend".equals(data.action) && data.targetUuid != null) {
                UUID targetUuid = UUID.fromString(data.targetUuid);
                FriendDataService.addBlock(this.playerRef.getUuid(), targetUuid);
                PlayerData targetData = PlayerDataService.getByUUID(targetUuid);
                String name = targetData != null ? targetData.getDisplayName() : data.targetUuid;
                String var18 = PrefixManager.friendsystem();
                player.sendMessage(Message.raw((String)(var18 + String.format(Langs.minerva().friendRequestBlockedSuccess(), name))));
                this.selectedFriendUuid = null;
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if ("teleport_friend".equals(data.action) && data.targetUuid != null) {
                boolean canTeleport = false;
                try {
                    canTeleport = Configs.friendsystem().isAllowTeleportToFriends();
                }
                catch (Exception targetData) {
                    // empty catch block
                }
                if (!canTeleport) {
                    String var17 = PrefixManager.friendsystem();
                    player.sendMessage(Message.raw((String)(var17 + Langs.minerva().friendTeleportDisabled())));
                    return;
                }
                UUID targetUuid = UUID.fromString(data.targetUuid);
                World world = player.getWorld();
                PlayerRef targetRef = this.findOnlinePlayer(world, targetUuid);
                if (targetRef == null) {
                    String var10001 = PrefixManager.friendsystem();
                    player.sendMessage(Message.raw((String)(var10001 + Langs.minerva().friendTeleportOffline())));
                    return;
                }
                Vector3f targetPos = TeleportService.getPosition((Store<EntityStore>)targetRef.getReference().getStore(), (Ref<EntityStore>)targetRef.getReference());
                if (targetPos != null) {
                    TeleportService.teleport(world, ref, store, targetPos);
                }
            } else if ("switch_subtab".equals(data.action)) {
                this.currentSubTab = data.subTab;
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if ("manage_mystock".equals(data.action) && data.stockId != null) {
                player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardManageStock(), data.stockId)));
            }
        }
    }

    private void buildMarket(UICommandBuilder builder, UIEventBuilder eventBuilder) {
        builder.clear("#StocksList");
        List<StockData> stocks = StockDataService.getAllStocks();
        if (stocks != null && !stocks.isEmpty()) {
            for (int i = 0; i < Math.min(stocks.size(), 15); ++i) {
                StockData s2 = stocks.get(i);
                String selector = "#StocksList[" + i + "]";
                builder.append("#StocksList", "Minerva/ReportEntry.ui");
                String line = String.format(Langs.minerva().dashboardMarketEntry(), s2.getName(), s2.getSymbol(), s2.getPrice().doubleValue(), s2.getAvailableShares());
                builder.set(selector + ".Text", line);
            }
        } else {
            builder.append("#StocksList", "Minerva/ReportEntry.ui");
            builder.set("#StocksList[0].Text", Langs.minerva().dashboardStocksEmpty());
        }
    }

    private void buildPortfolio(UICommandBuilder builder, UIEventBuilder eventBuilder) {
        builder.clear("#PortfolioList");
        List<PlayerStockData> myStocks = StockDataService.getPlayerStocks(this.playerRef.getUuid());
        if (myStocks.isEmpty()) {
            builder.append("#PortfolioList", "Minerva/ReportEntry.ui");
            builder.set("#PortfolioList[0].Text", Langs.minerva().dashboardPortfolioEmpty());
        } else {
            for (int i = 0; i < Math.min(myStocks.size(), 15); ++i) {
                PlayerStockData psd = myStocks.get(i);
                StockData s2 = StockDataService.getStock(psd.getStockId());
                String name = s2 != null ? s2.getName() + " (" + s2.getSymbol() + ")" : String.format(Langs.minerva().dashboardPortfolioUnknownStock(), psd.getStockId());
                double profit = 0.0;
                if (s2 != null) {
                    profit = (s2.getPrice().doubleValue() - psd.getAverageBuyPrice().doubleValue()) * (double)psd.getShares();
                }
                String line = String.format(Langs.minerva().dashboardPortfolioEntry(), name, psd.getShares(), psd.getAverageBuyPrice().doubleValue(), profit);
                String selector = "#PortfolioList[" + i + "]";
                builder.append("#PortfolioList", "Minerva/ReportEntry.ui");
                builder.set(selector + ".Text", line);
            }
        }
    }

    private void buildMyStock(UICommandBuilder builder, UIEventBuilder eventBuilder) {
        builder.clear("#MyStockPanel");
        List<StockData> myCompanies = StockDataService.getStocksByOwner(this.playerRef.getUuid());
        if (myCompanies.isEmpty()) {
            builder.append("#MyStockPanel", "Minerva/ReportEntry.ui");
            builder.set("#MyStockPanel[0].Text", Langs.minerva().dashboardMyStockEmpty());
        } else {
            for (int i = 0; i < myCompanies.size(); ++i) {
                StockData s2 = myCompanies.get(i);
                String line = String.format(Langs.minerva().dashboardMyStockEntry(), s2.getName(), s2.getSymbol(), s2.getPrice().doubleValue(), s2.getTotalShares());
                String selector = "#MyStockPanel[" + i + "]";
                builder.append("#MyStockPanel", "Minerva/ReportEntry.ui");
                builder.set(selector + ".Text", line);
            }
        }
    }

    private PlayerRef findOnlinePlayer(World world, UUID targetUuid) {
        try {
            Object worldsObj;
            Object universe = this.tryGetUniverseFromWorld(world);
            if (universe != null && (worldsObj = this.tryGetWorldsMap(universe)) instanceof Map) {
                Map worlds = (Map)worldsObj;
                for (Object w : worlds.values()) {
                    if (!(w instanceof World)) continue;
                    World worldRef = (World)w;
                    for (PlayerRef ref : worldRef.getPlayerRefs()) {
                        if (!ref.getUuid().equals(targetUuid)) continue;
                        return ref;
                    }
                }
            }
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            // empty catch block
        }
        for (PlayerRef ref : world.getPlayerRefs()) {
            if (!ref.getUuid().equals(targetUuid)) continue;
            return ref;
        }
        return null;
    }

    private Object tryGetUniverseFromWorld(World world) throws ReflectiveOperationException {
        try {
            return world.getClass().getMethod("getUniverse", new Class[0]).invoke((Object)world, new Object[0]);
        }
        catch (ReflectiveOperationException var4) {
            Class<?> serverClass = Class.forName("com.hypixel.hytale.server.core.HytaleServer");
            Object server = serverClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            return serverClass.getMethod("getUniverse", new Class[0]).invoke(server, new Object[0]);
        }
    }

    private Object tryGetWorldsMap(Object universe) throws ReflectiveOperationException {
        try {
            return universe.getClass().getMethod("getWorlds", new Class[0]).invoke(universe, new Object[0]);
        }
        catch (ReflectiveOperationException var4) {
            try {
                Field field = universe.getClass().getDeclaredField("unmodifiableWorlds");
                field.setAccessible(true);
                return field.get(universe);
            }
            catch (ReflectiveOperationException var3) {
                Field field = universe.getClass().getDeclaredField("worlds");
                field.setAccessible(true);
                return field.get(universe);
            }
        }
    }
}

