/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.dashboard;

import ch.serverrocket.dashboard.DashboardPage;
import ch.serverrocket.dashboard.FriendRequestsPageEventData;
import ch.serverrocket.database.friends.FriendDataService;
import ch.serverrocket.database.friends.Friendship;
import ch.serverrocket.database.player.PlayerData;
import ch.serverrocket.database.player.PlayerDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.List;
import java.util.UUID;

public class FriendRequestsPage
extends InteractiveCustomUIPage<FriendRequestsPageEventData> {
    public static final String LAYOUT = "Minerva/FriendRequests.ui";
    private final PlayerRef playerRef;
    private String selectedUuid;

    public FriendRequestsPage(PlayerRef playerRef) {
        super(playerRef, CustomPageLifetime.CanDismiss, FriendRequestsPageEventData.CODEC);
        this.playerRef = playerRef;
    }

    public void build(Ref<EntityStore> ref, UICommandBuilder builder, UIEventBuilder eventBuilder, Store<EntityStore> store) {
        builder.append(LAYOUT);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#RequestsBackButton", new EventData().append("Action", "back"), false);
        builder.clear("#RequestsList");
        List<Friendship> pending = FriendDataService.getPendingRequests(this.playerRef.getUuid());
        if (pending.isEmpty()) {
            builder.append("#RequestsList", "Minerva/ReportEntry.ui");
            builder.set("#RequestsList[0].Text", Langs.minerva().friendRequestsEmpty());
            builder.set("#RequestActions.Visible", false);
        } else {
            boolean selectedStillPending = false;
            for (int i = 0; i < pending.size(); ++i) {
                UUID requesterUuid = pending.get(i).getUuid1();
                PlayerData data = PlayerDataService.getByUUID(requesterUuid);
                String name = data != null ? data.getDisplayName() : requesterUuid.toString();
                String selector = "#RequestsList[" + i + "]";
                builder.append("#RequestsList", "Minerva/ReportEntry.ui");
                builder.set(selector + ".Text", name);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector, new EventData().append("Action", "select_request").append("TargetUuid", requesterUuid.toString()), false);
                if (!requesterUuid.toString().equals(this.selectedUuid)) continue;
                selectedStillPending = true;
            }
            if (!selectedStillPending) {
                this.selectedUuid = null;
            }
            if (this.selectedUuid != null) {
                PlayerData selectedData = PlayerDataService.getByUUID(UUID.fromString(this.selectedUuid));
                String selectedName = selectedData != null ? selectedData.getDisplayName() : this.selectedUuid;
                builder.set("#SelectedRequestLabel.Text", String.format(Langs.minerva().friendRequestsSelected(), selectedName));
                builder.set("#RequestActions.Visible", true);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#RequestAccept", new EventData().append("Action", "accept_request").append("TargetUuid", this.selectedUuid), false);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#RequestDeny", new EventData().append("Action", "deny_request").append("TargetUuid", this.selectedUuid), false);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#RequestBlock", new EventData().append("Action", "block_request").append("TargetUuid", this.selectedUuid), false);
            } else {
                builder.set("#RequestActions.Visible", false);
            }
        }
    }

    public void handleDataEvent(Ref<EntityStore> ref, Store<EntityStore> store, FriendRequestsPageEventData data) {
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player != null) {
            if ("back".equals(data.action)) {
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)new DashboardPage(this.playerRef));
            } else if ("select_request".equals(data.action) && data.targetUuid != null) {
                this.selectedUuid = data.targetUuid;
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if (data.targetUuid != null) {
                String requesterName;
                UUID requesterUuid = UUID.fromString(data.targetUuid);
                PlayerData requesterData = PlayerDataService.getByUUID(requesterUuid);
                String string = requesterName = requesterData != null ? requesterData.getDisplayName() : requesterUuid.toString();
                if ("accept_request".equals(data.action)) {
                    FriendDataService.acceptRequest(requesterUuid, this.playerRef.getUuid());
                    String var10001 = PrefixManager.friendsystem();
                    player.sendMessage(Message.raw((String)(var10001 + String.format(Langs.minerva().friendRequestAccepted(), requesterName))));
                    this.selectedUuid = null;
                    player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
                } else if ("deny_request".equals(data.action)) {
                    FriendDataService.removeFriend(requesterUuid, this.playerRef.getUuid());
                    String var8 = PrefixManager.friendsystem();
                    player.sendMessage(Message.raw((String)(var8 + String.format(Langs.minerva().friendRequestDenied(), requesterName))));
                    this.selectedUuid = null;
                    player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
                } else if ("block_request".equals(data.action)) {
                    FriendDataService.addBlock(this.playerRef.getUuid(), requesterUuid);
                    String var9 = PrefixManager.friendsystem();
                    player.sendMessage(Message.raw((String)(var9 + String.format(Langs.minerva().friendRequestBlockedSuccess(), requesterName))));
                    this.selectedUuid = null;
                    player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
                }
            }
        }
    }
}

