/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.duty;

import ch.serverrocket.config.Configs;
import ch.serverrocket.database.DatabaseManager;
import ch.serverrocket.database.duty.DutyData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DutyDataService {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOnDuty(UUID uuid) {
        String sql = "SELECT duties_status\nFROM Duties\nWHERE duties_player = ?\n";
        try {
            Connection connection = DatabaseManager.getConnection();
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, uuid.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean var5 = rs.getInt("duties_status") == 1;
                    return var5;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAutoDuty(UUID uuid) {
        String sql = "SELECT duties_auto\nFROM Duties\nWHERE duties_player = ?\n";
        try {
            Connection connection = DatabaseManager.getConnection();
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, uuid.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean var5 = rs.getInt("duties_auto") == 1;
                    return var5;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DutyData get(UUID uuid) {
        String sql = "SELECT duties_status, duties_auto\nFROM Duties\nWHERE duties_player = ?\n";
        try {
            Connection connection = DatabaseManager.getConnection();
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, uuid.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) {
                        DutyData dutyData = new DutyData(uuid, false, false);
                        return dutyData;
                    }
                    DutyData var5 = new DutyData(uuid, rs.getInt("duties_status") == 1, rs.getInt("duties_auto") == 1);
                    return var5;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DutyData(uuid, false, false);
        }
    }

    public static void setDuty(UUID uuid, boolean active) {
        String type = Configs.serverrocket().getDatabase().getType().toLowerCase();
        String sql = type.equals("sqlite") ? "INSERT INTO Duties (duties_player, duties_status)\nVALUES (?, ?)\nON CONFLICT(duties_player)\nDO UPDATE SET duties_status = excluded.duties_status\n" : "INSERT INTO Duties (duties_player, duties_status)\nVALUES (?, ?)\nON DUPLICATE KEY UPDATE duties_status = VALUES(duties_status)\n";
        try {
            Connection connection = DatabaseManager.getConnection();
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, uuid.toString());
                stmt.setInt(2, active ? 1 : 0);
                stmt.executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setAutoDuty(UUID uuid, boolean active) {
        String type = Configs.serverrocket().getDatabase().getType().toLowerCase();
        String sql = type.equals("sqlite") ? "INSERT INTO Duties (duties_player, duties_auto)\nVALUES (?, ?)\nON CONFLICT(duties_player)\nDO UPDATE SET duties_auto = excluded.duties_auto\n" : "INSERT INTO Duties (duties_player, duties_auto)\nVALUES (?, ?)\nON DUPLICATE KEY UPDATE duties_auto = VALUES(duties_auto)\n";
        try {
            Connection connection = DatabaseManager.getConnection();
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, uuid.toString());
                stmt.setInt(2, active ? 1 : 0);
                stmt.executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<UUID> getAllOnDuty() {
        ArrayList<UUID> result = new ArrayList<UUID>();
        String sql = "SELECT duties_player\nFROM Duties\nWHERE duties_status = 1\n";
        try {
            Connection connection = DatabaseManager.getConnection();
            try (PreparedStatement stmt = connection.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    result.add(UUID.fromString(rs.getString("duties_player")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

