/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.economy;

import ch.serverrocket.config.Configs;
import ch.serverrocket.database.DatabaseManager;
import ch.serverrocket.database.economy.TransactionData;
import ch.serverrocket.permissions.PermissionsManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class EconomyDataService {
    private EconomyDataService() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BigDecimal getBalance(UUID uuid) {
        String sql = "SELECT economy_balance FROM Economy WHERE economy_player = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) {
                    BigDecimal bigDecimal = uuid.equals(PermissionsManager.FEDERAL_BANK_UUID) ? BigDecimal.valueOf(Configs.stockmarket().getFederalBankStartingBalance()).setScale(2, RoundingMode.HALF_UP) : BigDecimal.valueOf(Configs.economy().getStartingBalance()).setScale(2, RoundingMode.HALF_UP);
                    return bigDecimal;
                }
                BigDecimal var4 = BigDecimal.valueOf(rs.getDouble("economy_balance")).setScale(2, RoundingMode.HALF_UP);
                return var4;
            }
        }
        catch (Exception e) {
            BigDecimal bigDecimal;
            e.printStackTrace();
            if (uuid.equals(PermissionsManager.FEDERAL_BANK_UUID)) {
                bigDecimal = BigDecimal.valueOf(Configs.stockmarket().getFederalBankStartingBalance()).setScale(2, RoundingMode.HALF_UP);
                return bigDecimal;
            }
            bigDecimal = BigDecimal.valueOf(Configs.economy().getStartingBalance()).setScale(2, RoundingMode.HALF_UP);
            return bigDecimal;
        }
    }

    public static void setBalance(UUID uuid, BigDecimal amount) {
        amount = amount.setScale(2, RoundingMode.HALF_UP);
        String type = Configs.serverrocket().getDatabase().getType().toLowerCase();
        String sql = type.equals("sqlite") ? "INSERT INTO Economy (economy_player, economy_balance) VALUES (?, ?) ON CONFLICT(economy_player) DO UPDATE SET economy_balance = excluded.economy_balance" : "INSERT INTO Economy (economy_player, economy_balance) VALUES (?, ?) ON DUPLICATE KEY UPDATE economy_balance = VALUES(economy_balance)";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            stmt.setDouble(2, amount.doubleValue());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setBalance(UUID uuid, double amount) {
        EconomyDataService.setBalance(uuid, BigDecimal.valueOf(amount));
    }

    public static void addMoney(UUID uuid, BigDecimal amount, String type, String description) {
        BigDecimal current = EconomyDataService.getBalance(uuid);
        EconomyDataService.setBalance(uuid, current.add(amount));
        EconomyDataService.logTransaction((UUID)null, uuid, amount, type, description);
    }

    public static void addMoney(UUID uuid, double amount, String type, String description) {
        EconomyDataService.addMoney(uuid, BigDecimal.valueOf(amount), type, description);
    }

    public static boolean removeMoney(UUID uuid, BigDecimal amount, String type, String description) {
        BigDecimal current = EconomyDataService.getBalance(uuid);
        boolean isFederalBank = uuid.equals(PermissionsManager.FEDERAL_BANK_UUID);
        if (!isFederalBank && !Configs.economy().isAllowNegativeBalance() && current.compareTo(amount) < 0) {
            return false;
        }
        EconomyDataService.setBalance(uuid, current.subtract(amount));
        EconomyDataService.logTransaction(uuid, (UUID)null, amount, type, description);
        return true;
    }

    public static boolean removeMoney(UUID uuid, double amount, String type, String description) {
        return EconomyDataService.removeMoney(uuid, BigDecimal.valueOf(amount), type, description);
    }

    public static boolean transfer(UUID sender, UUID receiver, BigDecimal amount, String description) {
        BigDecimal sBal = EconomyDataService.getBalance(sender);
        if (!Configs.economy().isAllowNegativeBalance() && sBal.compareTo(amount) < 0) {
            return false;
        }
        EconomyDataService.setBalance(sender, sBal.subtract(amount));
        EconomyDataService.setBalance(receiver, EconomyDataService.getBalance(receiver).add(amount));
        EconomyDataService.logTransaction(sender, receiver, amount, "TRANSFER", description);
        return true;
    }

    public static boolean transfer(UUID sender, UUID receiver, double amount, String description) {
        return EconomyDataService.transfer(sender, receiver, BigDecimal.valueOf(amount), description);
    }

    public static void logTransaction(UUID sender, UUID receiver, BigDecimal amount, String type, String description) {
        String sql = "INSERT INTO Transactions (trans_sender, trans_receiver, trans_amount, trans_timestamp, trans_type, trans_description) VALUES (?, ?, ?, ?, ?, ?)";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, sender != null ? sender.toString() : null);
            stmt.setString(2, receiver != null ? receiver.toString() : null);
            stmt.setDouble(3, amount.doubleValue());
            stmt.setLong(4, System.currentTimeMillis() / 1000L);
            stmt.setString(5, type);
            stmt.setString(6, description);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void logTransaction(UUID sender, UUID receiver, double amount, String type, String description) {
        EconomyDataService.logTransaction(sender, receiver, BigDecimal.valueOf(amount), type, description);
    }

    public static List<TransactionData> getHistory(UUID uuid) {
        ArrayList<TransactionData> history = new ArrayList<TransactionData>();
        String sql = "SELECT * FROM Transactions WHERE trans_sender = ? OR trans_receiver = ? ORDER BY trans_timestamp DESC";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, uuid.toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    history.add(EconomyDataService.fromResultSet(rs));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return history;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean rollback(int transactionId) {
        String sql = "SELECT * FROM Transactions WHERE trans_id = ? AND trans_rolledback = 0";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setInt(1, transactionId);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) {
                    boolean bl = false;
                    return bl;
                }
                TransactionData data = EconomyDataService.fromResultSet(rs);
                if (data.getSender() != null) {
                    EconomyDataService.setBalance(data.getSender(), EconomyDataService.getBalance(data.getSender()).add(data.getAmount()));
                }
                if (data.getReceiver() != null) {
                    EconomyDataService.setBalance(data.getReceiver(), EconomyDataService.getBalance(data.getReceiver()).subtract(data.getAmount()));
                }
                try (PreparedStatement update = DatabaseManager.getConnection().prepareStatement("UPDATE Transactions SET trans_rolledback = 1 WHERE trans_id = ?");){
                    update.setInt(1, transactionId);
                    update.executeUpdate();
                }
                EconomyDataService.logTransaction((UUID)null, (UUID)null, data.getAmount(), "ROLLBACK", "Rollback of Transaction #" + transactionId);
                boolean var15 = true;
                return var15;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static TransactionData fromResultSet(ResultSet rs) throws Exception {
        String s2 = rs.getString("trans_sender");
        String r = rs.getString("trans_receiver");
        return new TransactionData(rs.getInt("trans_id"), s2 != null ? UUID.fromString(s2) : null, r != null ? UUID.fromString(r) : null, BigDecimal.valueOf(rs.getDouble("trans_amount")).setScale(2, RoundingMode.HALF_UP), rs.getLong("trans_timestamp"), rs.getString("trans_type"), rs.getString("trans_description"), rs.getInt("trans_rolledback") == 1);
    }
}

