/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.friends;

import ch.serverrocket.config.Configs;
import ch.serverrocket.database.DatabaseManager;
import ch.serverrocket.database.friends.Friendship;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class FriendDataService {
    private FriendDataService() {
    }

    public static void addFriend(UUID sender, UUID receiver) {
        if (!FriendDataService.isBlocked(receiver, sender) && !FriendDataService.isBlocked(sender, receiver)) {
            String checkSql = "SELECT friends_status, friends_uuid1 FROM Friends WHERE (friends_uuid1 = ? AND friends_uuid2 = ?) OR (friends_uuid1 = ? AND friends_uuid2 = ?)";
            Connection conn = DatabaseManager.getConnection();
            try (PreparedStatement checkStmt = conn.prepareStatement(checkSql);){
                checkStmt.setString(1, sender.toString());
                checkStmt.setString(2, receiver.toString());
                checkStmt.setString(3, receiver.toString());
                checkStmt.setString(4, sender.toString());
                try (ResultSet rs = checkStmt.executeQuery();){
                    if (rs.next()) {
                        return;
                    }
                }
                String insertSql = "INSERT INTO Friends (friends_uuid1, friends_uuid2, friends_status, friends_timestamp) VALUES (?, ?, 0, ?)";
                try (PreparedStatement insertStmt = conn.prepareStatement(insertSql);){
                    insertStmt.setString(1, sender.toString());
                    insertStmt.setString(2, receiver.toString());
                    insertStmt.setLong(3, System.currentTimeMillis() / 1000L);
                    insertStmt.executeUpdate();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void acceptRequest(UUID requester, UUID receiver) {
        String sql = "SELECT friends_status FROM Friends WHERE friends_uuid1 = ? AND friends_uuid2 = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, requester.toString());
            stmt.setString(2, receiver.toString());
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next() && rs.getInt("friends_status") == 0) {
                    FriendDataService.updateStatus(requester, receiver, 1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addBlock(UUID blocker, UUID blocked) {
        String sql = "INSERT OR IGNORE INTO FriendsBlocked (blocker_uuid, blocked_uuid, blocked_timestamp) VALUES (?, ?, ?)";
        String type = Configs.serverrocket().getDatabase().getType().toLowerCase();
        if (!"sqlite".equals(type)) {
            sql = "INSERT IGNORE INTO FriendsBlocked (blocker_uuid, blocked_uuid, blocked_timestamp) VALUES (?, ?, ?)";
        }
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, blocker.toString());
            stmt.setString(2, blocked.toString());
            stmt.setLong(3, System.currentTimeMillis() / 1000L);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FriendDataService.removeFriend(blocker, blocked);
    }

    public static boolean isBlocked(UUID blocker, UUID blocked) {
        String sql = "SELECT 1 FROM FriendsBlocked WHERE blocker_uuid = ? AND blocked_uuid = ?";
        try {
            boolean var5;
            try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
                stmt.setString(1, blocker.toString());
                stmt.setString(2, blocked.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    var5 = rs.next();
                }
            }
            return var5;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void removeBlock(UUID blocker, UUID blocked) {
        String sql = "DELETE FROM FriendsBlocked WHERE blocker_uuid = ? AND blocked_uuid = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, blocker.toString());
            stmt.setString(2, blocked.toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateStatus(UUID u1, UUID u2, int status) {
        String sql = "UPDATE Friends SET friends_status = ? WHERE (friends_uuid1 = ? AND friends_uuid2 = ?) OR (friends_uuid1 = ? AND friends_uuid2 = ?)";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setInt(1, status);
            stmt.setString(2, u1.toString());
            stmt.setString(3, u2.toString());
            stmt.setString(4, u2.toString());
            stmt.setString(5, u1.toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeFriend(UUID u1, UUID u2) {
        String sql = "DELETE FROM Friends WHERE (friends_uuid1 = ? AND friends_uuid2 = ?) OR (friends_uuid1 = ? AND friends_uuid2 = ?)";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, u1.toString());
            stmt.setString(2, u2.toString());
            stmt.setString(3, u2.toString());
            stmt.setString(4, u1.toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Friendship> getFriends(UUID uuid) {
        ArrayList<Friendship> friendships = new ArrayList<Friendship>();
        String sql = "SELECT * FROM Friends WHERE (friends_uuid1 = ? OR friends_uuid2 = ?) AND friends_status = 1";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, uuid.toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    friendships.add(new Friendship(UUID.fromString(rs.getString("friends_uuid1")), UUID.fromString(rs.getString("friends_uuid2")), rs.getInt("friends_status"), rs.getLong("friends_timestamp")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return friendships;
    }

    public static List<Friendship> getPendingRequests(UUID uuid) {
        ArrayList<Friendship> friendships = new ArrayList<Friendship>();
        String sql = "SELECT * FROM Friends WHERE friends_uuid2 = ? AND friends_status = 0";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    friendships.add(new Friendship(UUID.fromString(rs.getString("friends_uuid1")), UUID.fromString(rs.getString("friends_uuid2")), rs.getInt("friends_status"), rs.getLong("friends_timestamp")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return friendships;
    }

    public static boolean areFriends(UUID u1, UUID u2) {
        String sql = "SELECT 1 FROM Friends WHERE ((friends_uuid1 = ? AND friends_uuid2 = ?) OR (friends_uuid1 = ? AND friends_uuid2 = ?)) AND friends_status = 1";
        try {
            boolean var5;
            try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
                stmt.setString(1, u1.toString());
                stmt.setString(2, u2.toString());
                stmt.setString(3, u2.toString());
                stmt.setString(4, u1.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    var5 = rs.next();
                }
            }
            return var5;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

