/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.player;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.UUID;

public final class PlayerData {
    private final UUID uuid;
    private String displayName;
    private long firstJoin;
    private long lastSeen;
    private long playtime;
    private long sessionJoinTimestamp;

    public static String formatDate(long timestamp) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return dateTime.format(formatter);
    }

    public static String formatPlaytime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return hours + "h " + minutes + "m";
    }

    public PlayerData(UUID uuid, String displayName, long firstJoin, long lastSeen, long playtime) {
        this.uuid = uuid;
        this.displayName = displayName;
        this.firstJoin = firstJoin;
        this.lastSeen = lastSeen;
        this.playtime = playtime;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getFirstJoin() {
        return this.firstJoin;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public long getPlaytime() {
        return this.playtime;
    }

    public void startSession() {
        this.sessionJoinTimestamp = System.currentTimeMillis() / 1000L;
    }

    public void endSession() {
        long now = System.currentTimeMillis() / 1000L;
        if (this.sessionJoinTimestamp > 0L) {
            this.playtime += now - this.sessionJoinTimestamp;
        }
        this.lastSeen = now;
    }
}

