/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.player;

import ch.serverrocket.config.Configs;
import ch.serverrocket.database.DatabaseManager;
import ch.serverrocket.database.player.PlayerData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class PlayerDataService {
    private static final Map<UUID, PlayerData> CACHE = new ConcurrentHashMap<UUID, PlayerData>();

    private PlayerDataService() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PlayerData getByUUID(UUID uuid) {
        String sql = "SELECT * FROM Players WHERE players_uuid = ?";
        try {
            Connection connection = DatabaseManager.getConnection();
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, uuid.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) {
                        PlayerData playerData = null;
                        return playerData;
                    }
                    PlayerData var5 = PlayerDataService.fromResultSet(rs);
                    return var5;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PlayerData getByName(String name) {
        String sql = "SELECT * FROM Players WHERE players_displayname = ?";
        try {
            Connection connection = DatabaseManager.getConnection();
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, name);
                try (ResultSet result = statement.executeQuery();){
                    if (!result.next()) {
                        PlayerData playerData = null;
                        return playerData;
                    }
                    PlayerData data = PlayerDataService.fromResultSet(result);
                    CACHE.put(data.getUuid(), data);
                    PlayerData var6 = data;
                    return var6;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void save(PlayerData data) {
        String type = Configs.serverrocket().getDatabase().getType().toLowerCase();
        String sql = type.equals("sqlite") ? "INSERT INTO Players (players_uuid, players_displayname, players_firstjoin, players_lastseen, players_playtime)\nVALUES (?, ?, ?, ?, ?)\nON CONFLICT(players_uuid) DO UPDATE SET\n    players_displayname = excluded.players_displayname,\n    players_lastseen = excluded.players_lastseen,\n    players_playtime = excluded.players_playtime\n" : "INSERT INTO Players (players_uuid, players_displayname, players_firstjoin, players_lastseen, players_playtime)\nVALUES (?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    players_displayname = VALUES(players_displayname),\n    players_lastseen = VALUES(players_lastseen),\n    players_playtime = VALUES(players_playtime)\n";
        try {
            Connection connection = DatabaseManager.getConnection();
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, data.getUuid().toString());
                stmt.setString(2, data.getDisplayName());
                stmt.setLong(3, data.getFirstJoin());
                stmt.setLong(4, data.getLastSeen());
                stmt.setLong(5, data.getPlaytime());
                stmt.executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveAndUnload(UUID uuid) {
        PlayerData data = CACHE.remove(uuid);
        if (data != null) {
            data.endSession();
            PlayerDataService.save(data);
        }
    }

    private static PlayerData fromResultSet(ResultSet result) throws Exception {
        return new PlayerData(UUID.fromString(result.getString("players_uuid")), result.getString("players_displayname"), result.getLong("players_firstjoin"), result.getLong("players_lastseen"), result.getLong("players_playtime"));
    }

    public static List<PlayerData> getAllPlayers() {
        ArrayList<PlayerData> players = new ArrayList<PlayerData>();
        String sql = "SELECT * FROM Players WHERE players_displayname IS NOT NULL ORDER BY players_displayname ASC";
        try {
            Connection connection = DatabaseManager.getConnection();
            try (PreparedStatement stmt = connection.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    players.add(PlayerDataService.fromResultSet(rs));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return players;
    }

    public static PlayerData loadOrCreate(UUID uuid, String displayName) {
        PlayerData data = PlayerDataService.getByUUID(uuid);
        if (data != null) {
            data.startSession();
            CACHE.put(uuid, data);
            return data;
        }
        long now = System.currentTimeMillis() / 1000L;
        PlayerData created = new PlayerData(uuid, displayName, now, now, 0L);
        created.startSession();
        PlayerDataService.save(created);
        CACHE.put(uuid, created);
        return created;
    }
}

