/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.reports;

import ch.serverrocket.database.DatabaseManager;
import ch.serverrocket.database.reports.ModerationHistoryData;
import ch.serverrocket.database.reports.ModerationReasonData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class ModerationDataService {
    private ModerationDataService() {
    }

    public static void addModerationReason(String type, String name, Integer defaultDuration) {
        String sql = "INSERT INTO ModerationReasons (modreason_type, modreason_name, modreason_default_duration) VALUES (?, ?, ?)";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, type.toUpperCase());
            stmt.setString(2, name);
            if (defaultDuration != null) {
                stmt.setInt(3, defaultDuration);
            } else {
                stmt.setNull(3, 4);
            }
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeModerationReason(String name) {
        String sql = "DELETE FROM ModerationReasons WHERE modreason_name = ?";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, name);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setStatus(String name, int status) {
        String sql = "UPDATE ModerationReasons SET modreason_status = ? WHERE modreason_name = ?";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setInt(1, status);
            stmt.setString(2, name);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean exists(String name) {
        String sql = "SELECT 1 FROM ModerationReasons WHERE modreason_name = ?";
        Connection connection = DatabaseManager.getConnection();
        try {
            boolean var5;
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, name);
                try (ResultSet rs = stmt.executeQuery();){
                    var5 = rs.next();
                }
            }
            return var5;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModerationReasonData getReasonByName(String name) {
        String sql = "SELECT * FROM ModerationReasons WHERE modreason_name = ?";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, name);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) {
                    ModerationReasonData moderationReasonData = null;
                    return moderationReasonData;
                }
                ModerationReasonData var5 = ModerationDataService.fromReasonResultSet(rs);
                return var5;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModerationReasonData getReasonById(int id) {
        String sql = "SELECT * FROM ModerationReasons WHERE modreason_id = ?";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setInt(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) {
                    ModerationReasonData moderationReasonData = null;
                    return moderationReasonData;
                }
                ModerationReasonData var5 = ModerationDataService.fromReasonResultSet(rs);
                return var5;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<ModerationReasonData> getReasonsByType(String type) {
        ArrayList<ModerationReasonData> reasons = new ArrayList<ModerationReasonData>();
        String sql = "SELECT * FROM ModerationReasons WHERE modreason_type = ? AND modreason_status = 1 ORDER BY modreason_id ASC";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, type.toUpperCase());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    reasons.add(ModerationDataService.fromReasonResultSet(rs));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reasons;
    }

    public static ModerationReasonData getReasonByIndex(String type, int index) {
        List<ModerationReasonData> reasons = ModerationDataService.getReasonsByType(type);
        return index > 0 && index <= reasons.size() ? reasons.get(index - 1) : null;
    }

    public static List<ModerationReasonData> getAllReasons() {
        ArrayList<ModerationReasonData> reasons = new ArrayList<ModerationReasonData>();
        String sql = "SELECT * FROM ModerationReasons ORDER BY modreason_type ASC, modreason_id ASC";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                reasons.add(ModerationDataService.fromReasonResultSet(rs));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reasons;
    }

    public static boolean hasModerations(String name) {
        String sql = "SELECT 1 FROM ModerationHistory mh JOIN ModerationReasons mr ON mh.mod_reason_id = mr.modreason_id WHERE mr.modreason_name = ? LIMIT 1";
        Connection connection = DatabaseManager.getConnection();
        try {
            boolean var5;
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, name);
                try (ResultSet rs = stmt.executeQuery();){
                    var5 = rs.next();
                }
            }
            return var5;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static ModerationReasonData fromReasonResultSet(ResultSet rs) throws Exception {
        Integer duration = rs.getObject("modreason_default_duration") != null ? Integer.valueOf(rs.getInt("modreason_default_duration")) : null;
        return new ModerationReasonData(rs.getInt("modreason_id"), rs.getString("modreason_type"), rs.getString("modreason_name"), duration, rs.getInt("modreason_status"));
    }

    public static void recordModeration(UUID target, UUID staff, String type, Integer reasonId, String customReason, Long expiry) {
        Connection connection = DatabaseManager.getConnection();
        try {
            try (PreparedStatement up = connection.prepareStatement("UPDATE ModerationHistory SET mod_active = 0 WHERE mod_target = ? AND mod_type = ? AND mod_active = 1");){
                up.setString(1, target.toString());
                up.setString(2, type.toUpperCase());
                up.executeUpdate();
            }
            String sql = "INSERT INTO ModerationHistory (mod_target, mod_staff, mod_type, mod_reason_id, mod_custom_reason, mod_timestamp, mod_expiry) VALUES (?, ?, ?, ?, ?, ?, ?)";
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, target.toString());
                stmt.setString(2, staff.toString());
                stmt.setString(3, type.toUpperCase());
                if (reasonId != null) {
                    stmt.setInt(4, reasonId);
                } else {
                    stmt.setNull(4, 4);
                }
                stmt.setString(5, customReason);
                stmt.setLong(6, System.currentTimeMillis() / 1000L);
                if (expiry != null) {
                    stmt.setLong(7, expiry);
                } else {
                    stmt.setNull(7, -5);
                }
                stmt.executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModerationHistoryData getActiveModeration(UUID target, String type) {
        String sql = "SELECT mh.*, mr.modreason_name FROM ModerationHistory mh\nLEFT JOIN ModerationReasons mr ON mh.mod_reason_id = mr.modreason_id\nWHERE mh.mod_target = ? AND mh.mod_type = ? AND mh.mod_active = 1\nAND (mh.mod_expiry IS NULL OR mh.mod_expiry > ?)\nORDER BY mh.mod_timestamp DESC LIMIT 1\n";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, target.toString());
            stmt.setString(2, type.toUpperCase());
            stmt.setLong(3, System.currentTimeMillis() / 1000L);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) {
                    ModerationHistoryData moderationHistoryData = null;
                    return moderationHistoryData;
                }
                ModerationHistoryData var6 = ModerationDataService.fromHistoryResultSet(rs);
                return var6;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void deactivateModeration(UUID target, String type) {
        String sql = "UPDATE ModerationHistory SET mod_active = 0 WHERE mod_target = ? AND mod_type = ? AND mod_active = 1";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, target.toString());
            stmt.setString(2, type.toUpperCase());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<ModerationHistoryData> getModerationHistory(UUID target) {
        ArrayList<ModerationHistoryData> history = new ArrayList<ModerationHistoryData>();
        String sql = "SELECT mh.*, mr.modreason_name FROM ModerationHistory mh\nLEFT JOIN ModerationReasons mr ON mh.mod_reason_id = mr.modreason_id\nWHERE mh.mod_target = ?\nORDER BY mh.mod_timestamp DESC\n";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, target.toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    history.add(ModerationDataService.fromHistoryResultSet(rs));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return history;
    }

    private static ModerationHistoryData fromHistoryResultSet(ResultSet rs) throws Exception {
        String finalReason;
        Integer reasonId = rs.getObject("mod_reason_id") != null ? Integer.valueOf(rs.getInt("mod_reason_id")) : null;
        Long expiry = rs.getObject("mod_expiry") != null ? Long.valueOf(rs.getLong("mod_expiry")) : null;
        String reasonName = null;
        try {
            reasonName = rs.getString("modreason_name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String customReason = rs.getString("mod_custom_reason");
        String string = finalReason = customReason != null && !customReason.isEmpty() ? customReason : reasonName;
        if (finalReason == null) {
            finalReason = "Banned";
        }
        return new ModerationHistoryData(rs.getInt("mod_id"), UUID.fromString(rs.getString("mod_target")), UUID.fromString(rs.getString("mod_staff")), rs.getString("mod_type"), reasonId, finalReason, rs.getLong("mod_timestamp"), expiry, rs.getInt("mod_active") == 1);
    }
}

