/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.reports;

import java.util.UUID;

public final class ModerationHistoryData {
    private final int id;
    private final UUID target;
    private final UUID staff;
    private final String type;
    private final Integer reasonId;
    private final String customReason;
    private final long timestamp;
    private final Long expiry;
    private final boolean active;

    public ModerationHistoryData(int id, UUID target, UUID staff, String type, Integer reasonId, String customReason, long timestamp, Long expiry, boolean active) {
        this.id = id;
        this.target = target;
        this.staff = staff;
        this.type = type;
        this.reasonId = reasonId;
        this.customReason = customReason;
        this.timestamp = timestamp;
        this.expiry = expiry;
        this.active = active;
    }

    public int getId() {
        return this.id;
    }

    public UUID getTarget() {
        return this.target;
    }

    public UUID getStaff() {
        return this.staff;
    }

    public String getType() {
        return this.type;
    }

    public Integer getReasonId() {
        return this.reasonId;
    }

    public String getCustomReason() {
        return this.customReason;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Long getExpiry() {
        return this.expiry;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isExpired() {
        if (this.expiry == null) {
            return false;
        }
        return System.currentTimeMillis() / 1000L > this.expiry;
    }
}

