/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.reports;

import ch.serverrocket.database.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class ReportAuditService {
    private ReportAuditService() {
    }

    public static void logAction(int reportId, UUID staff, String action, String details) {
        String sql = "INSERT INTO ReportAuditLog (report_id, staff_uuid, action, details, timestamp) VALUES (?, ?, ?, ?, ?)";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setInt(1, reportId);
            stmt.setString(2, staff.toString());
            stmt.setString(3, action);
            stmt.setString(4, details);
            stmt.setLong(5, System.currentTimeMillis() / 1000L);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<ReportAuditEntry> getAuditLog(int reportId) {
        ArrayList<ReportAuditEntry> entries = new ArrayList<ReportAuditEntry>();
        String sql = "SELECT * FROM ReportAuditLog WHERE report_id = ? ORDER BY timestamp ASC";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setInt(1, reportId);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    entries.add(new ReportAuditEntry(rs.getInt("audit_id"), rs.getInt("report_id"), UUID.fromString(rs.getString("staff_uuid")), rs.getString("action"), rs.getString("details"), rs.getLong("timestamp")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entries;
    }

    public record ReportAuditEntry(int id, int reportId, UUID staffUuid, String action, String details, long timestamp) {
    }
}

