/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.reports;

import ch.serverrocket.config.Configs;
import ch.serverrocket.database.DatabaseManager;
import ch.serverrocket.database.reports.ReportsData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class ReportsDataService {
    private ReportsDataService() {
    }

    public static void createReport(UUID reporter, UUID reported, int reasonId, String comment) {
        String sql = "INSERT INTO Reports (reports_reporter, reports_reported, reports_reason_id, reports_timestamp, reports_comment, reports_source_server) VALUES (?, ?, ?, ?, ?, ?)";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, reporter.toString());
            stmt.setString(2, reported.toString());
            stmt.setInt(3, reasonId);
            stmt.setLong(4, System.currentTimeMillis() / 1000L);
            stmt.setString(5, comment);
            stmt.setString(6, Configs.serverrocket().getNetwork().getCurrentServer());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateReportStatus(int reportId, UUID staffUuid, int status) {
        String sql = "UPDATE Reports SET reports_staff = ?, reports_status = ? WHERE reports_id = ?";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, staffUuid != null ? staffUuid.toString() : null);
            stmt.setInt(2, status);
            stmt.setInt(3, reportId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void closeReport(int reportId, UUID staffUuid, String comment) {
        String sql = "UPDATE Reports SET reports_staff = ?, reports_status = 2, reports_comment = reports_comment || ' | Staff Comment: ' || ? WHERE reports_id = ?";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, staffUuid.toString());
            stmt.setString(2, comment != null ? comment : "No comment provided");
            stmt.setInt(3, reportId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<ReportsData> getReports(boolean openOnly) {
        ArrayList<ReportsData> reports = new ArrayList<ReportsData>();
        String sql = openOnly ? "SELECT * FROM Reports WHERE reports_status IN (0, 1)" : "SELECT * FROM Reports WHERE reports_status = 2";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                reports.add(ReportsDataService.fromResultSet(rs));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reports;
    }

    public static List<ReportsData> getOpenReports() {
        return ReportsDataService.getReports(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ReportsData getById(int id) {
        String sql = "SELECT * FROM Reports WHERE reports_id = ?";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setInt(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) {
                    ReportsData reportsData = null;
                    return reportsData;
                }
                ReportsData var5 = ReportsDataService.fromResultSet(rs);
                return var5;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ReportsData fromResultSet(ResultSet rs) throws Exception {
        String staffStr = rs.getString("reports_staff");
        UUID staffUuid = staffStr != null ? UUID.fromString(staffStr) : null;
        String sourceServer = rs.getString("reports_source_server");
        if (sourceServer == null) {
            sourceServer = Configs.serverrocket().getNetwork().getCurrentServer();
        }
        return new ReportsData(rs.getInt("reports_id"), UUID.fromString(rs.getString("reports_reporter")), UUID.fromString(rs.getString("reports_reported")), staffUuid, rs.getInt("reports_reason_id"), rs.getLong("reports_timestamp"), rs.getString("reports_comment"), rs.getInt("reports_status"), sourceServer);
    }
}

