/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.reports;

import ch.serverrocket.database.DatabaseManager;
import ch.serverrocket.database.reports.ReportsReasonData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public final class ReportsReasonDataService {
    private ReportsReasonDataService() {
    }

    public static void addReason(String name, String description, int priority) {
        String sql = "INSERT INTO ReportsReason (reportsreason_name, reportsreason_description, reportsreason_priority) VALUES (?, ?, ?)";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, name);
            stmt.setString(2, description);
            stmt.setInt(3, priority);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeReason(String name) {
        String sql = "DELETE FROM ReportsReason WHERE reportsreason_name = ?";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, name);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setStatus(String name, int status) {
        String sql = "UPDATE ReportsReason SET reportsreason_status = ? WHERE reportsreason_name = ?";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setInt(1, status);
            stmt.setString(2, name);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean exists(String name) {
        String sql = "SELECT 1 FROM ReportsReason WHERE reportsreason_name = ?";
        Connection connection = DatabaseManager.getConnection();
        try {
            boolean var5;
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, name);
                try (ResultSet rs = stmt.executeQuery();){
                    var5 = rs.next();
                }
            }
            return var5;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasReports(String name) {
        String sql = "SELECT 1 FROM Reports r\nJOIN ReportsReason rr ON r.reports_reason_id = rr.reportsreason_id\nWHERE rr.reportsreason_name = ?\nLIMIT 1\n";
        Connection connection = DatabaseManager.getConnection();
        try {
            boolean var5;
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                stmt.setString(1, name);
                try (ResultSet rs = stmt.executeQuery();){
                    var5 = rs.next();
                }
            }
            return var5;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ReportsReasonData getByName(String name) {
        String sql = "SELECT * FROM ReportsReason WHERE reportsreason_name = ?";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, name);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) {
                    ReportsReasonData reportsReasonData = null;
                    return reportsReasonData;
                }
                ReportsReasonData var5 = new ReportsReasonData(rs.getInt("reportsreason_id"), rs.getString("reportsreason_name"), rs.getString("reportsreason_description"), rs.getInt("reportsreason_priority"), rs.getInt("reportsreason_status"));
                return var5;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ReportsReasonData getById(int id) {
        String sql = "SELECT * FROM ReportsReason WHERE reportsreason_id = ?";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setInt(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) {
                    ReportsReasonData reportsReasonData = null;
                    return reportsReasonData;
                }
                ReportsReasonData var5 = new ReportsReasonData(rs.getInt("reportsreason_id"), rs.getString("reportsreason_name"), rs.getString("reportsreason_description"), rs.getInt("reportsreason_priority"), rs.getInt("reportsreason_status"));
                return var5;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<ReportsReasonData> getActiveReasons() {
        ArrayList<ReportsReasonData> reasons = new ArrayList<ReportsReasonData>();
        String sql = "SELECT * FROM ReportsReason WHERE reportsreason_status = 1 ORDER BY reportsreason_priority DESC";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                reasons.add(new ReportsReasonData(rs.getInt("reportsreason_id"), rs.getString("reportsreason_name"), rs.getString("reportsreason_description"), rs.getInt("reportsreason_priority"), rs.getInt("reportsreason_status")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reasons;
    }

    public static List<ReportsReasonData> getAllReasons() {
        ArrayList<ReportsReasonData> reasons = new ArrayList<ReportsReasonData>();
        String sql = "SELECT * FROM ReportsReason ORDER BY reportsreason_priority DESC";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                reasons.add(new ReportsReasonData(rs.getInt("reportsreason_id"), rs.getString("reportsreason_name"), rs.getString("reportsreason_description"), rs.getInt("reportsreason_priority"), rs.getInt("reportsreason_status")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reasons;
    }
}

