/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.reports;

import ch.serverrocket.database.DatabaseManager;
import ch.serverrocket.database.reports.ModerationDataService;
import ch.serverrocket.database.reports.ModerationHistoryData;
import ch.serverrocket.lang.Langs;
import com.hypixel.hytale.server.core.modules.accesscontrol.provider.AccessProvider;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class ServerRocketAccessProvider
implements AccessProvider {
    @Nonnull
    public CompletableFuture<Optional<String>> getDisconnectReason(UUID uuid) {
        try {
            try {
                DatabaseManager.getConnection();
            }
            catch (IllegalStateException var9) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            ModerationHistoryData activeBan = ModerationDataService.getActiveModeration(uuid, "BAN");
            if (activeBan != null) {
                Object expiryStr;
                String reason = activeBan.getCustomReason();
                if (activeBan.getExpiry() == null) {
                    expiryStr = "Permanent";
                } else {
                    long diffSeconds = activeBan.getExpiry() - System.currentTimeMillis() / 1000L;
                    long minutes = (diffSeconds + 59L) / 60L;
                    if (minutes < 0L) {
                        minutes = 0L;
                    }
                    expiryStr = minutes + " Minutes";
                }
                String message = String.format(Langs.minerva().moderationPlayerBanned(), reason, expiryStr);
                return CompletableFuture.completedFuture(Optional.of(message));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }
}

