/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.database.stockmarket;

import ch.serverrocket.config.Configs;
import ch.serverrocket.database.DatabaseManager;
import ch.serverrocket.database.economy.EconomyDataService;
import ch.serverrocket.database.stockmarket.LimitOrder;
import ch.serverrocket.database.stockmarket.PlayerStockData;
import ch.serverrocket.database.stockmarket.StockData;
import ch.serverrocket.permissions.PermissionsManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class StockDataService {
    private static final Map<Integer, Long> federalBankCooldowns = new HashMap<Integer, Long>();

    private StockDataService() {
    }

    public static List<StockData> getAllStocks() {
        ArrayList<StockData> stocks = new ArrayList<StockData>();
        String sql = "SELECT * FROM Stocks";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                stocks.add(StockDataService.fromResultSet(rs));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stocks;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static StockData getStock(int id) {
        String sql = "SELECT * FROM Stocks WHERE stock_id = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            StockData stockData;
            block18: {
                StockData stockData2;
                ResultSet rs;
                block16: {
                    StockData stockData3;
                    block17: {
                        stmt.setInt(1, id);
                        rs = stmt.executeQuery();
                        try {
                            if (rs.next()) break block16;
                            stockData3 = null;
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return stockData3;
                }
                stockData = stockData2 = StockDataService.fromResultSet(rs);
                if (rs == null) break block18;
                rs.close();
            }
            return stockData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean createStock(String name, String symbol, UUID owner, BigDecimal price, int shares) {
        boolean bl = false;
        String sql = "INSERT INTO Stocks (stock_name, stock_symbol, stock_owner, stock_price, stock_last_price, stock_total_shares, stock_available_shares) VALUES (?, ?, ?, ?, ?, ?, ?)";
        Connection connection = DatabaseManager.getConnection();
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, name);
            stmt.setString(2, symbol);
            stmt.setString(3, owner != null ? owner.toString() : null);
            stmt.setDouble(4, price.doubleValue());
            stmt.setDouble(5, price.doubleValue());
            stmt.setInt(6, shares);
            stmt.setInt(7, shares);
            stmt.executeUpdate();
            bl = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bl;
    }

    public static boolean createStock(String name, String symbol, UUID owner, double price, int shares) {
        return StockDataService.createStock(name, symbol, owner, BigDecimal.valueOf(price), shares);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PlayerStockData getPlayerStock(UUID playerUuid, int stockId) {
        String sql = "SELECT * FROM PlayerStocks WHERE player_uuid = ? AND stock_id = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            PlayerStockData playerStockData;
            block18: {
                PlayerStockData playerStockData2;
                ResultSet rs;
                block16: {
                    PlayerStockData playerStockData3;
                    block17: {
                        stmt.setString(1, playerUuid.toString());
                        stmt.setInt(2, stockId);
                        rs = stmt.executeQuery();
                        try {
                            if (rs.next()) break block16;
                            playerStockData3 = new PlayerStockData(playerUuid, stockId, 0, BigDecimal.ZERO, BigDecimal.ZERO);
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return playerStockData3;
                }
                playerStockData = playerStockData2 = new PlayerStockData(playerUuid, stockId, rs.getInt("shares"), BigDecimal.valueOf(rs.getDouble("average_buy_price")).setScale(2, RoundingMode.HALF_UP), BigDecimal.valueOf(rs.getDouble("realized_profit")).setScale(2, RoundingMode.HALF_UP));
                if (rs == null) break block18;
                rs.close();
            }
            return playerStockData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new PlayerStockData(playerUuid, stockId, 0, BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }

    public static int getSharesOwned(UUID playerUuid, int stockId) {
        return StockDataService.getPlayerStock(playerUuid, stockId).getShares();
    }

    public static void setPlayerStock(PlayerStockData data) {
        String sql = "INSERT INTO PlayerStocks (player_uuid, stock_id, shares, average_buy_price, realized_profit) VALUES (?, ?, ?, ?, ?) ON CONFLICT(player_uuid, stock_id) DO UPDATE SET shares = excluded.shares, average_buy_price = excluded.average_buy_price, realized_profit = excluded.realized_profit";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, data.getPlayerUuid().toString());
            stmt.setInt(2, data.getStockId());
            stmt.setInt(3, data.getShares());
            stmt.setDouble(4, data.getAverageBuyPrice().doubleValue());
            stmt.setDouble(5, data.getRealizedProfit().doubleValue());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setSharesOwned(UUID playerUuid, int stockId, int shares) {
        PlayerStockData current = StockDataService.getPlayerStock(playerUuid, stockId);
        StockDataService.setPlayerStock(new PlayerStockData(playerUuid, stockId, shares, current.getAverageBuyPrice(), current.getRealizedProfit()));
    }

    public static void updateAvailableShares(int stockId, int newAvailable) {
        String sql = "UPDATE Stocks SET stock_available_shares = ? WHERE stock_id = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setInt(1, newAvailable);
            stmt.setInt(2, stockId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateStockPrice(int stockId, BigDecimal newPrice) {
        if (Configs.stockmarket().isEnablePriceLimits()) {
            BigDecimal min2 = BigDecimal.valueOf(Configs.stockmarket().getMinPricePerStock());
            BigDecimal max = BigDecimal.valueOf(Configs.stockmarket().getMaxPricePerStock());
            if (newPrice.compareTo(min2) < 0) {
                newPrice = min2;
            }
            if (newPrice.compareTo(max) > 0) {
                newPrice = max;
            }
        }
        String sql = "UPDATE Stocks SET stock_last_price = stock_price, stock_price = ? WHERE stock_id = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            StockData stock;
            stmt.setDouble(1, newPrice.doubleValue());
            stmt.setInt(2, stockId);
            stmt.executeUpdate();
            StockDataService.checkLimitOrders(stockId, newPrice);
            if (Configs.stockmarket().isEnableFederalBank() && Configs.stockmarket().isFederalBankReactToExtremePrice() && (stock = StockDataService.getStock(stockId)) != null) {
                StockDataService.checkFederalBankIntervention(stock);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<LimitOrder> getLimitOrders(int stockId) {
        ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>();
        String sql = "SELECT * FROM LimitOrders WHERE stock_id = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setInt(1, stockId);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    orders.add(new LimitOrder(rs.getInt("order_id"), rs.getInt("stock_id"), UUID.fromString(rs.getString("player_uuid")), LimitOrder.OrderType.valueOf(rs.getString("order_type")), rs.getInt("amount"), BigDecimal.valueOf(rs.getDouble("target_price")).setScale(2, RoundingMode.HALF_UP)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orders;
    }

    public static void createLimitOrder(int stockId, UUID playerUuid, LimitOrder.OrderType type, int amount, BigDecimal targetPrice) {
        String sql = "INSERT INTO LimitOrders (stock_id, player_uuid, order_type, amount, target_price) VALUES (?, ?, ?, ?, ?)";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setInt(1, stockId);
            stmt.setString(2, playerUuid.toString());
            stmt.setString(3, type.name());
            stmt.setInt(4, amount);
            stmt.setDouble(5, targetPrice.doubleValue());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteLimitOrder(int orderId) {
        String sql = "DELETE FROM LimitOrders WHERE order_id = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setInt(1, orderId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkLimitOrders(int stockId, BigDecimal currentPrice) {
        List<LimitOrder> orders = StockDataService.getLimitOrders(stockId);
        boolean enablePartial = Configs.stockmarket().isEnablePartialFills();
        for (LimitOrder order : orders) {
            boolean triggered = false;
            if (order.getType() == LimitOrder.OrderType.BUY && currentPrice.compareTo(order.getTargetPrice()) <= 0) {
                triggered = true;
            } else if (order.getType() == LimitOrder.OrderType.SELL && currentPrice.compareTo(order.getTargetPrice()) >= 0) {
                triggered = true;
            }
            if (!triggered) continue;
            if (order.getType() == LimitOrder.OrderType.BUY) {
                StockDataService.handleLimitBuy(order, enablePartial);
                continue;
            }
            StockDataService.handleLimitSell(order, enablePartial);
        }
    }

    private static void handleLimitBuy(LimitOrder order, boolean enablePartial) {
        StockData stock = StockDataService.getStock(order.getStockId());
        if (stock == null) {
            return;
        }
        int available = stock.getAvailableShares();
        if (available <= 0) {
            return;
        }
        int toBuy = Math.min(order.getAmount(), available);
        BigDecimal price = stock.getPrice();
        BigDecimal cost = price.multiply(BigDecimal.valueOf(toBuy));
        double feePercent = Configs.stockmarket().getTradingFeePercent();
        BigDecimal fee = cost.multiply(BigDecimal.valueOf(feePercent)).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        BigDecimal totalCost = cost.add(fee);
        if (EconomyDataService.removeMoney(order.getPlayerUuid(), totalCost, "LIMIT_BUY", "Limit Buy " + stock.getSymbol())) {
            PlayerStockData ps = StockDataService.getPlayerStock(order.getPlayerUuid(), order.getStockId());
            int newShares = ps.getShares() + toBuy;
            BigDecimal oldTotalCost = ps.getAverageBuyPrice().multiply(BigDecimal.valueOf(ps.getShares()));
            BigDecimal newAvgPrice = oldTotalCost.add(cost).divide(BigDecimal.valueOf(newShares), 2, RoundingMode.HALF_UP);
            StockDataService.setPlayerStock(new PlayerStockData(order.getPlayerUuid(), order.getStockId(), newShares, newAvgPrice, ps.getRealizedProfit()));
            StockDataService.updateAvailableShares(order.getStockId(), available - toBuy);
            if (toBuy >= order.getAmount()) {
                StockDataService.deleteLimitOrder(order.getOrderId());
            } else if (enablePartial) {
                StockDataService.updateLimitOrderAmount(order.getOrderId(), order.getAmount() - toBuy);
            }
        }
    }

    private static void handleLimitSell(LimitOrder order, boolean enablePartial) {
        PlayerStockData ps = StockDataService.getPlayerStock(order.getPlayerUuid(), order.getStockId());
        if (ps.getShares() <= 0) {
            StockDataService.deleteLimitOrder(order.getOrderId());
            return;
        }
        int toSell = Math.min(order.getAmount(), ps.getShares());
        StockData stock = StockDataService.getStock(order.getStockId());
        if (stock == null) {
            return;
        }
        BigDecimal price = stock.getPrice();
        BigDecimal gain = price.multiply(BigDecimal.valueOf(toSell));
        double feePercent = Configs.stockmarket().getTradingFeePercent();
        BigDecimal fee = gain.multiply(BigDecimal.valueOf(feePercent)).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        BigDecimal netGain = gain.subtract(fee);
        EconomyDataService.addMoney(order.getPlayerUuid(), netGain, "LIMIT_SELL", "Limit Sell " + stock.getSymbol());
        BigDecimal costOfSoldShares = ps.getAverageBuyPrice().multiply(BigDecimal.valueOf(toSell));
        BigDecimal profitFromTrade = gain.subtract(costOfSoldShares).subtract(fee);
        BigDecimal newRealizedProfit = ps.getRealizedProfit().add(profitFromTrade);
        StockDataService.setPlayerStock(new PlayerStockData(order.getPlayerUuid(), order.getStockId(), ps.getShares() - toSell, ps.getAverageBuyPrice(), newRealizedProfit));
        StockDataService.updateAvailableShares(order.getStockId(), stock.getAvailableShares() + toSell);
        if (toSell >= order.getAmount()) {
            StockDataService.deleteLimitOrder(order.getOrderId());
        } else if (enablePartial) {
            StockDataService.updateLimitOrderAmount(order.getOrderId(), order.getAmount() - toSell);
        }
    }

    public static void updateLimitOrderAmount(int orderId, int newAmount) {
        String sql = "UPDATE LimitOrders SET amount = ? WHERE order_id = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setInt(1, newAmount);
            stmt.setInt(2, orderId);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void payoutDividends(BigDecimal amountPerShare) {
        List<StockData> allStocks = StockDataService.getAllStocks();
        for (StockData stock : allStocks) {
            BigDecimal totalPayout = BigDecimal.ZERO;
            String sql = "SELECT player_uuid, shares FROM PlayerStocks WHERE stock_id = ? AND shares > 0";
            try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
                stmt.setInt(1, stock.getId());
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        UUID playerUuid = UUID.fromString(rs.getString("player_uuid"));
                        if (playerUuid.equals(PermissionsManager.FEDERAL_BANK_UUID)) continue;
                        int shares = rs.getInt("shares");
                        BigDecimal payout = amountPerShare.multiply(BigDecimal.valueOf(shares)).setScale(2, RoundingMode.HALF_UP);
                        EconomyDataService.addMoney(playerUuid, payout, "DIVIDEND", "Dividend for " + stock.getSymbol());
                        totalPayout = totalPayout.add(payout);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (totalPayout.compareTo(BigDecimal.ZERO) <= 0) continue;
            StockDataService.logDividend(stock.getId(), totalPayout, amountPerShare);
        }
    }

    private static void logDividend(int stockId, BigDecimal totalAmount, BigDecimal perShare) {
        String sql = "INSERT INTO DividendLog (stock_id, total_amount, amount_per_share, timestamp) VALUES (?, ?, ?, ?)";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setInt(1, stockId);
            stmt.setDouble(2, totalAmount.doubleValue());
            stmt.setDouble(3, perShare.doubleValue());
            stmt.setLong(4, System.currentTimeMillis() / 1000L);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static StockData getStockBySymbol(String symbol) {
        String sql = "SELECT * FROM Stocks WHERE stock_symbol = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            StockData stockData;
            block18: {
                StockData stockData2;
                ResultSet rs;
                block16: {
                    StockData stockData3;
                    block17: {
                        stmt.setString(1, symbol);
                        rs = stmt.executeQuery();
                        try {
                            if (rs.next()) break block16;
                            stockData3 = null;
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return stockData3;
                }
                stockData = stockData2 = StockDataService.fromResultSet(rs);
                if (rs == null) break block18;
                rs.close();
            }
            return stockData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void forceFederalBankIntervention(StockData stock, String action, Integer volumeOverride) {
    }

    private static void executeFederalBankTrade(StockData stock, UUID bankUuid, int volume, boolean isBuy, boolean forced) {
    }

    public static void checkFederalBankIntervention(StockData stock) {
    }

    private static void executeFederalBankTrade(StockData stock, UUID bankUuid, int volume, boolean isBuy) {
        StockDataService.executeFederalBankTrade(stock, bankUuid, volume, isBuy, false);
    }

    private static void completeFederalBankTrade(StockData stock, UUID bankUuid, int amount, boolean isBuy, BigDecimal totalMoney, boolean forced) {
    }

    private static void completeFederalBankTrade(StockData stock, UUID bankUuid, int amount, boolean isBuy, BigDecimal totalMoney) {
    }

    public static List<FederalBankAction> getFederalBankActions() {
        return new ArrayList<FederalBankAction>();
    }

    private static void logFederalBankAction(int stockId, String action, int amount, BigDecimal price) {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int getStocksCountByOwner(UUID owner) {
        String sql = "SELECT COUNT(*) FROM Stocks WHERE stock_owner = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            int n;
            block18: {
                int n2;
                ResultSet rs;
                block16: {
                    int n3;
                    block17: {
                        stmt.setString(1, owner.toString());
                        rs = stmt.executeQuery();
                        try {
                            if (rs.next()) break block16;
                            n3 = 0;
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return n3;
                }
                n = n2 = rs.getInt(1);
                if (rs == null) break block18;
                rs.close();
            }
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static List<PlayerStockData> getPlayerStocks(UUID playerUuid) {
        ArrayList<PlayerStockData> stocks = new ArrayList<PlayerStockData>();
        String sql = "SELECT * FROM PlayerStocks WHERE player_uuid = ? AND shares > 0";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, playerUuid.toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    stocks.add(new PlayerStockData(UUID.fromString(rs.getString("player_uuid")), rs.getInt("stock_id"), rs.getInt("shares"), BigDecimal.valueOf(rs.getDouble("average_buy_price")), BigDecimal.valueOf(rs.getDouble("realized_profit"))));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stocks;
    }

    public static List<StockData> getStocksByOwner(UUID owner) {
        ArrayList<StockData> stocks = new ArrayList<StockData>();
        String sql = "SELECT * FROM Stocks WHERE stock_owner = ?";
        try (PreparedStatement stmt = DatabaseManager.getConnection().prepareStatement(sql);){
            stmt.setString(1, owner.toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    stocks.add(StockDataService.fromResultSet(rs));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stocks;
    }

    public static void splitStock(int stockId, int numerator, int denominator) {
        StockData stock = StockDataService.getStock(stockId);
        if (stock == null) {
            return;
        }
        BigDecimal oldPrice = stock.getPrice();
        BigDecimal ratio = BigDecimal.valueOf(numerator).divide(BigDecimal.valueOf(denominator), 10, RoundingMode.HALF_UP);
        BigDecimal newPrice = oldPrice.divide(ratio, 2, RoundingMode.HALF_UP);
        String updateStocks = "UPDATE Stocks SET stock_total_shares = ROUND(stock_total_shares * ?), stock_available_shares = ROUND(stock_available_shares * ?), stock_price = ?, stock_last_price = ? WHERE stock_id = ?";
        String updatePlayerStocks = "UPDATE PlayerStocks SET shares = ROUND(shares * ?), average_buy_price = average_buy_price / ? WHERE stock_id = ?";
        String logSplit = "INSERT INTO StockSplitLog (stock_id, ratio_numerator, ratio_denominator, old_price, new_price, timestamp) VALUES (?, ?, ?, ?, ?, ?)";
        try {
            Connection conn = DatabaseManager.getConnection();
            conn.setAutoCommit(false);
            try (PreparedStatement stmt1 = conn.prepareStatement(updateStocks);
                 PreparedStatement stmt2 = conn.prepareStatement(updatePlayerStocks);
                 PreparedStatement stmt3 = conn.prepareStatement(logSplit);){
                double ratioDouble = ratio.doubleValue();
                stmt1.setDouble(1, ratioDouble);
                stmt1.setDouble(2, ratioDouble);
                stmt1.setDouble(3, newPrice.doubleValue());
                stmt1.setDouble(4, newPrice.doubleValue());
                stmt1.setInt(5, stockId);
                stmt1.executeUpdate();
                stmt2.setDouble(1, ratioDouble);
                stmt2.setDouble(2, ratioDouble);
                stmt2.setInt(3, stockId);
                stmt2.executeUpdate();
                stmt3.setInt(1, stockId);
                stmt3.setInt(2, numerator);
                stmt3.setInt(3, denominator);
                stmt3.setDouble(4, oldPrice.doubleValue());
                stmt3.setDouble(5, newPrice.doubleValue());
                stmt3.setLong(6, System.currentTimeMillis() / 1000L);
                stmt3.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                conn.rollback();
                throw e;
            }
            finally {
                conn.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static StockData fromResultSet(ResultSet rs) throws Exception {
        String ownerStr = rs.getString("stock_owner");
        return new StockData(rs.getInt("stock_id"), rs.getString("stock_name"), rs.getString("stock_symbol"), ownerStr != null ? UUID.fromString(ownerStr) : null, BigDecimal.valueOf(rs.getDouble("stock_price")).setScale(2, RoundingMode.HALF_UP), BigDecimal.valueOf(rs.getDouble("stock_last_price")).setScale(2, RoundingMode.HALF_UP), rs.getInt("stock_total_shares"), rs.getInt("stock_available_shares"));
    }

    public static class FederalBankAction {
        private final int id;
        private final int stockId;
        private final String actionType;
        private final int amount;
        private final BigDecimal price;
        private final long timestamp;

        public FederalBankAction(int id, int stockId, String actionType, int amount, BigDecimal price, long timestamp) {
            this.id = id;
            this.stockId = stockId;
            this.actionType = actionType;
            this.amount = amount;
            this.price = price;
            this.timestamp = timestamp;
        }

        public int getId() {
            return this.id;
        }

        public int getStockId() {
            return this.stockId;
        }

        public String getActionType() {
            return this.actionType;
        }

        public int getAmount() {
            return this.amount;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

