/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.economy;

import ch.serverrocket.database.economy.EconomyDataService;
import ch.serverrocket.database.economy.TransactionData;
import ch.serverrocket.database.player.PlayerData;
import ch.serverrocket.database.player.PlayerDataService;
import ch.serverrocket.economy.EconomyDashboardPageEventData;
import ch.serverrocket.economy.MoneyCommand;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class EconomyDashboardPage
extends InteractiveCustomUIPage<EconomyDashboardPageEventData> {
    public static final String LAYOUT = "Minerva/EconomyDashboard.ui";
    private final PlayerRef playerRef;

    public EconomyDashboardPage(PlayerRef playerRef) {
        super(playerRef, CustomPageLifetime.CanDismiss, EconomyDashboardPageEventData.CODEC);
        this.playerRef = playerRef;
    }

    public void build(Ref<EntityStore> ref, UICommandBuilder builder, UIEventBuilder eventBuilder, Store<EntityStore> store) {
        boolean isAdmin;
        builder.append(LAYOUT);
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        boolean bl = isAdmin = player != null && player.hasPermission("serverrocket.economy.admin");
        if (isAdmin) {
            builder.set("#AdminTab.Visible", true);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#AdminTab", new EventData().append("Action", "switch_tab").append("Tab", "admin"), false);
        }
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#HistoryTab", new EventData().append("Action", "switch_tab").append("Tab", "history"), false);
        this.updateBalance(builder);
        this.buildHistory(builder, eventBuilder, 0);
    }

    private void updateBalance(UICommandBuilder builder) {
        BigDecimal balance = EconomyDataService.getBalance(this.playerRef.getUuid());
        builder.set("#BalanceLabel.Text", "Balance: " + MoneyCommand.format(balance.doubleValue()));
    }

    private void hideAll(UICommandBuilder builder) {
        builder.set("#HistoryArea.Visible", false);
        builder.set("#AdminArea.Visible", false);
        builder.set("#AdminDetailArea.Visible", false);
    }

    private void buildHistory(UICommandBuilder builder, UIEventBuilder eventBuilder, int page) {
        this.hideAll(builder);
        builder.set("#HistoryArea.Visible", true);
        builder.clear("#HistoryList");
        List<TransactionData> history = EconomyDataService.getHistory(this.playerRef.getUuid());
        this.renderHistoryList(builder, eventBuilder, history, "#HistoryList", page, false, this.playerRef.getUuid());
        int total = history.size();
        int pageSize = 8;
        int totalPages = Math.max(1, (int)Math.ceil((double)total / (double)pageSize));
        builder.set("#HistoryPageLabel.Text", "Page " + (page + 1) + "/" + totalPages);
        builder.set("#HistoryPrev.Visible", page > 0);
        if (page > 0) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#HistoryPrev", new EventData().append("Action", "history_page").append("Page", String.valueOf(page - 1)), false);
        }
        builder.set("#HistoryNext.Visible", page < totalPages - 1);
        if (page < totalPages - 1) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#HistoryNext", new EventData().append("Action", "history_page").append("Page", String.valueOf(page + 1)), false);
        }
    }

    private void renderHistoryList(UICommandBuilder builder, UIEventBuilder eventBuilder, List<TransactionData> history, String container, int page, boolean canRollback, UUID viewer) {
        int pageSize = 8;
        int start = page * pageSize;
        int end = Math.min(start + pageSize, history.size());
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM HH:mm");
        for (int i = start; i < end; ++i) {
            TransactionData trans = history.get(i);
            int idx = i - start;
            String selector = container + "[" + idx + "]";
            builder.append(container, "Minerva/TransactionEntry.ui");
            String amountStr = MoneyCommand.format(trans.getAmount().doubleValue());
            String color = "#ffffff";
            String prefix = "";
            if (trans.getReceiver() != null && trans.getReceiver().equals(viewer)) {
                color = "#55ff55";
                prefix = "+";
            } else if (trans.getSender() != null && trans.getSender().equals(viewer)) {
                color = "#ff5555";
                prefix = "-";
            }
            String rb = trans.isRolledBack() ? " [ROLLED BACK]" : "";
            String type = trans.getType();
            String date = sdf.format(new Date(trans.getTimestamp() * 1000L));
            builder.set(selector + " #TransInfo.Text", date + " | " + type + " | " + prefix + amountStr + rb);
            builder.set(selector + " #TransInfo.Style.TextColor", color);
            if (!canRollback || trans.isRolledBack()) continue;
            builder.set(selector + " #RollbackButton.Visible", true);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector + " #RollbackButton", new EventData().append("Action", "rollback").append("TransId", String.valueOf(trans.getId())).append("TargetUuid", viewer.toString()), false);
        }
    }

    private void buildAdminPlayers(UICommandBuilder builder, UIEventBuilder eventBuilder) {
        this.hideAll(builder);
        builder.set("#AdminArea.Visible", true);
        builder.clear("#PlayerList");
        List<PlayerData> players = PlayerDataService.getAllPlayers();
        for (int i = 0; i < players.size(); ++i) {
            PlayerData data = players.get(i);
            String selector = "#PlayerList[" + i + "]";
            builder.append("#PlayerList", "Minerva/ReportEntry.ui");
            BigDecimal balance = EconomyDataService.getBalance(data.getUuid());
            String var10001 = selector + ".Text";
            String var10002 = data.getDisplayName();
            builder.set(var10001, var10002 + " - Balance: " + MoneyCommand.format(balance.doubleValue()));
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector, new EventData().append("Action", "admin_view_player").append("TargetUuid", data.getUuid().toString()), false);
        }
    }

    private void buildAdminDetail(UICommandBuilder builder, UIEventBuilder eventBuilder, UUID targetUuid) {
        this.hideAll(builder);
        builder.set("#AdminDetailArea.Visible", true);
        builder.clear("#AdminDetailList");
        PlayerData data = PlayerDataService.getByUUID(targetUuid);
        Object var10002 = data != null ? data.getDisplayName() : targetUuid;
        builder.set("#AdminDetailTitle.Text", "History for " + String.valueOf(var10002));
        List<TransactionData> history = EconomyDataService.getHistory(targetUuid);
        this.renderHistoryList(builder, eventBuilder, history, "#AdminDetailList", 0, true, targetUuid);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#AdminDetailBack", new EventData().append("Action", "switch_tab").append("Tab", "admin"), false);
    }

    public void handleDataEvent(Ref<EntityStore> ref, Store<EntityStore> store, EconomyDashboardPageEventData data) {
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        UICommandBuilder builder = new UICommandBuilder();
        UIEventBuilder eventBuilder = new UIEventBuilder();
        if ("switch_tab".equals(data.action)) {
            if ("history".equals(data.tab)) {
                this.buildHistory(builder, eventBuilder, 0);
            } else if ("admin".equals(data.tab) && player != null && player.hasPermission("serverrocket.economy.admin")) {
                this.buildAdminPlayers(builder, eventBuilder);
            }
        } else if ("history_page".equals(data.action)) {
            int page = 0;
            try {
                page = Integer.parseInt(data.page);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.buildHistory(builder, eventBuilder, page);
        } else if ("admin_view_player".equals(data.action) && data.targetUuid != null) {
            this.buildAdminDetail(builder, eventBuilder, UUID.fromString(data.targetUuid));
        } else if ("rollback".equals(data.action) && data.transId != null && player != null && player.hasPermission("serverrocket.economy.rollback")) {
            int id = Integer.parseInt(data.transId);
            boolean success = EconomyDataService.rollback(id);
            if (success) {
                String var10001 = PrefixManager.economy();
                player.sendMessage(Message.raw((String)(var10001 + String.format(Langs.economy().rollbackSuccess(), id))));
            } else {
                String var11 = PrefixManager.economy();
                player.sendMessage(Message.raw((String)(var11 + Langs.economy().rollbackFailed())));
            }
            if (data.targetUuid != null) {
                this.buildAdminDetail(builder, eventBuilder, UUID.fromString(data.targetUuid));
            }
        }
        this.sendUpdate(builder, eventBuilder, false);
    }
}

