/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.economy;

import ch.serverrocket.database.economy.EconomyDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.math.BigDecimal;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class MoneyCommand
extends AbstractPlayerCommand {
    public MoneyCommand() {
        super("money", "economy.commands.money.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.economy.money")) {
            String var7 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var7 + " " + Langs.serverrocket().noPermission())));
        } else {
            BigDecimal balance = EconomyDataService.getBalance(playerRef.getUuid());
            String var10001 = PrefixManager.economy();
            context.sendMessage(Message.raw((String)(var10001 + String.format(Langs.economy().balanceOwn(), MoneyCommand.format(balance.doubleValue())))));
        }
    }

    public static String format(double amount) {
        return String.format("%.2f$", amount);
    }
}

