/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.economy;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.database.economy.EconomyDataService;
import ch.serverrocket.economy.MoneyCommand;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class PayCommand
extends AbstractPlayerCommand {
    private final RequiredArg<PlayerRef> targetArg = this.withRequiredArg("player", "economy.pay.target", (ArgumentType)ArgTypes.PLAYER_REF);
    private final RequiredArg<Double> amountArg = this.withRequiredArg("amount", "economy.pay.amount", (ArgumentType)ArgTypes.DOUBLE);

    public PayCommand() {
        super("pay", "economy.commands.pay.desc");
        CommandUsage.addUsageVariant((AbstractCommand)this);
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.economy.pay")) {
            String var13 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var13 + " " + Langs.serverrocket().noPermission())));
        } else if (CommandUsage.requireArgs(context, new Argument[]{this.targetArg, this.amountArg})) {
            PlayerRef target = (PlayerRef)this.targetArg.get(context);
            Double amount = (Double)this.amountArg.get(context);
            if (amount != null && !(amount <= 0.0)) {
                if (target.getUuid().equals(playerRef.getUuid())) {
                    context.sendMessage(Message.raw((String)(PrefixManager.economy() + "You cannot pay yourself.")));
                } else {
                    boolean success = EconomyDataService.transfer(playerRef.getUuid(), target.getUuid(), amount, "Player Pay");
                    if (success) {
                        String formatted = MoneyCommand.format(amount);
                        String var10 = PrefixManager.economy();
                        context.sendMessage(Message.raw((String)(var10 + String.format(Langs.economy().paySuccessSender(), formatted, target.getUsername()))));
                        var10 = PrefixManager.economy();
                        target.sendMessage(Message.raw((String)(var10 + String.format(Langs.economy().paySuccessReceiver(), formatted, playerRef.getUsername()))));
                    } else {
                        String var12 = PrefixManager.economy();
                        context.sendMessage(Message.raw((String)(var12 + Langs.economy().payNotEnoughMoney())));
                    }
                }
            } else {
                String var10001 = PrefixManager.economy();
                context.sendMessage(Message.raw((String)(var10001 + Langs.economy().payUsage())));
            }
        }
    }
}

