/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.economy.subcommands;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.database.economy.EconomyDataService;
import ch.serverrocket.economy.MoneyCommand;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.math.BigDecimal;
import java.util.UUID;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class EcoResetCommand
extends AbstractPlayerCommand {
    private final RequiredArg<PlayerRef> targetArg = this.withRequiredArg("player", "economy.eco.target", (ArgumentType)ArgTypes.PLAYER_REF);

    public EcoResetCommand() {
        super("reset", "economy.commands.eco.reset.desc");
        CommandUsage.addUsageVariant((AbstractCommand)this);
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.economy.admin")) {
            String var8 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var8 + " " + Langs.serverrocket().noPermission())));
        } else if (CommandUsage.requireArgs(context, new Argument[]{this.targetArg})) {
            PlayerRef target = (PlayerRef)this.targetArg.get(context);
            EconomyDataService.setBalance(target.getUuid(), 0.0);
            EconomyDataService.logTransaction((UUID)null, target.getUuid(), 0.0, "ADMIN_RESET", "Reset by admin " + playerRef.getUsername());
            BigDecimal newBalance = EconomyDataService.getBalance(target.getUuid());
            String var10001 = PrefixManager.economy();
            context.sendMessage(Message.raw((String)(var10001 + String.format(Langs.economy().ecoSuccess(), target.getUsername(), MoneyCommand.format(newBalance.doubleValue())))));
        }
    }
}

