/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.friendsystem.subcommands;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.database.friends.FriendDataService;
import ch.serverrocket.database.friends.Friendship;
import ch.serverrocket.database.player.PlayerDataService;
import ch.serverrocket.friendsystem.FriendCommand;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class FriendAddSubCommand
extends AbstractPlayerCommand {
    private final RequiredArg<PlayerRef> targetArg = this.withRequiredArg("player", "friend.target", (ArgumentType)ArgTypes.PLAYER_REF);

    public FriendAddSubCommand() {
        super("add", "serverrocket.friendsystem.friend.add.desc");
        CommandUsage.addUsageVariant((AbstractCommand)this);
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (CommandUsage.requireArgs(context, new Argument[]{this.targetArg})) {
            PlayerRef target = (PlayerRef)this.targetArg.get(context);
            if (target == null) {
                String var13 = PrefixManager.friendsystem();
                context.sendMessage(Message.raw((String)(var13 + Langs.minerva().friendUsageAdd())));
            } else if (target.getUuid().equals(playerRef.getUuid())) {
                String var12 = PrefixManager.friendsystem();
                context.sendMessage(Message.raw((String)(var12 + Langs.minerva().friendCannotAddSelf())));
            } else if (!FriendDataService.isBlocked(target.getUuid(), playerRef.getUuid()) && !FriendDataService.isBlocked(playerRef.getUuid(), target.getUuid())) {
                int limit = FriendCommand.getFriendLimit(context);
                List<Friendship> friends = FriendDataService.getFriends(playerRef.getUuid());
                if (limit != -1 && friends.size() >= limit) {
                    String var11 = PrefixManager.friendsystem();
                    context.sendMessage(Message.raw((String)(var11 + String.format(Langs.minerva().friendLimitReached(), limit))));
                } else {
                    PlayerDataService.loadOrCreate(playerRef.getUuid(), playerRef.getUsername());
                    PlayerDataService.loadOrCreate(target.getUuid(), target.getUsername());
                    FriendDataService.addFriend(playerRef.getUuid(), target.getUuid());
                    String var9 = PrefixManager.friendsystem();
                    context.sendMessage(Message.raw((String)(var9 + String.format(Langs.minerva().friendRequestSent(), target.getUsername()))));
                    var9 = PrefixManager.friendsystem();
                    target.sendMessage(Message.raw((String)(var9 + String.format(Langs.minerva().friendRequestReceived(), playerRef.getUsername(), playerRef.getUsername()))));
                }
            } else {
                String var10001 = PrefixManager.friendsystem();
                context.sendMessage(Message.raw((String)(var10001 + Langs.minerva().friendRequestBlocked())));
            }
        }
    }
}

