/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.friendsystem.subcommands;

import ch.serverrocket.database.friends.FriendDataService;
import ch.serverrocket.database.friends.Friendship;
import ch.serverrocket.database.player.PlayerData;
import ch.serverrocket.database.player.PlayerDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class FriendListSubCommand
extends AbstractPlayerCommand {
    public FriendListSubCommand() {
        super("list", "serverrocket.friendsystem.friend.list.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        UUID uuid = playerRef.getUuid();
        List<Friendship> friends = FriendDataService.getFriends(uuid);
        if (friends.isEmpty()) {
            String var13 = PrefixManager.friendsystem();
            context.sendMessage(Message.raw((String)(var13 + Langs.minerva().friendListEmpty())));
        } else {
            String var10001 = PrefixManager.friendsystem();
            context.sendMessage(Message.raw((String)(var10001 + Langs.minerva().friendListHeader())));
            for (Friendship f : friends) {
                UUID friendUuid = f.getFriendOf(uuid);
                PlayerData data = PlayerDataService.getByUUID(friendUuid);
                String name = data != null ? data.getDisplayName() : friendUuid.toString();
                context.sendMessage(Message.raw((String)(" - " + name)));
            }
        }
    }
}

