/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.friendsystem.subcommands;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.database.friends.FriendDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class FriendRemoveSubCommand
extends AbstractPlayerCommand {
    private final RequiredArg<PlayerRef> targetArg = this.withRequiredArg("player", "friend.target", (ArgumentType)ArgTypes.PLAYER_REF);

    public FriendRemoveSubCommand() {
        super("remove", "serverrocket.friendsystem.friend.remove.desc");
        CommandUsage.addUsageVariant((AbstractCommand)this);
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (CommandUsage.requireArgs(context, new Argument[]{this.targetArg})) {
            PlayerRef target = (PlayerRef)this.targetArg.get(context);
            if (target == null) {
                String var7 = PrefixManager.friendsystem();
                context.sendMessage(Message.raw((String)(var7 + Langs.minerva().friendUsageRemove())));
            } else {
                FriendDataService.removeFriend(playerRef.getUuid(), target.getUuid());
                String var10001 = PrefixManager.friendsystem();
                context.sendMessage(Message.raw((String)(var10001 + String.format(Langs.minerva().friendRemoved(), target.getUsername()))));
            }
        }
    }
}

