/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.lang;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hypixel.hytale.logger.HytaleLogger;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class LangManager {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T load(File file, Class<T> type) {
        try (FileReader reader = new FileReader(file);){
            T t2 = this.gson.fromJson((Reader)reader, type);
            return t2;
        }
        catch (IOException e) {
            ((HytaleLogger.Api)HytaleLogger.getLogger().atSevere()).log("Failed to load lang file " + file.getName(), (Object)e);
            try {
                return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create default lang", ex);
            }
        }
    }
}

