/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.lang;

import ch.serverrocket.lang.LangManager;
import ch.serverrocket.main.Main;
import com.hypixel.hytale.logger.HytaleLogger;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;

public class LangService {
    private static final HytaleLogger LOGGER = HytaleLogger.forEnclosingClass();
    private final File langRoot = new File(Main.getInstance().getDataDirectory().toFile(), "lang");
    private final LangManager langManager = new LangManager();
    private final Map<String, Object> langs = new HashMap<String, Object>();

    public LangService(Main plugin) {
        this.langRoot.mkdirs();
    }

    public <T> void load(String language, String fileName, Class<T> type) {
        try {
            File langDir = new File(this.langRoot, language);
            langDir.mkdirs();
            File file = new File(langDir, fileName);
            if (!file.exists()) {
                this.copyDefault(language, fileName, file);
            }
            T lang = this.langManager.load(file, type);
            this.langs.put(language + ":" + fileName, lang);
        }
        catch (Exception e) {
            ((HytaleLogger.Api)LOGGER.atSevere()).log("Failed to load lang " + language + "/" + fileName, (Object)e);
        }
    }

    public <T> T get(String language, String fileName, Class<T> type) {
        return (T)this.langs.get(language + ":" + fileName);
    }

    private void copyDefault(String language, String fileName, File target) throws Exception {
        String path = "/lang/" + language + "/" + fileName;
        try (InputStream in = this.getClass().getResourceAsStream(path);){
            if (in == null) {
                throw new IllegalStateException("Resource " + path + " not found");
            }
            Files.copy(in, target.toPath(), new CopyOption[0]);
        }
    }
}

