/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.lang;

import ch.serverrocket.config.Configs;
import ch.serverrocket.lang.EconomyLang;
import ch.serverrocket.lang.LangService;
import ch.serverrocket.lang.MinervaLang;
import ch.serverrocket.lang.ServerRocketLang;
import ch.serverrocket.lang.StockMarketLang;
import ch.serverrocket.lang.UtilityLang;

public final class Langs {
    private static LangService service;

    private Langs() {
    }

    public static void init(LangService langService) {
        service = langService;
    }

    private static String defaultLang() {
        return Configs.serverrocket().getLanguage();
    }

    public static MinervaLang minerva() {
        Langs.checkInitialized();
        return service.get(Langs.defaultLang(), "minerva.json", MinervaLang.class);
    }

    public static EconomyLang economy() {
        Langs.checkInitialized();
        return service.get(Langs.defaultLang(), "economy.json", EconomyLang.class);
    }

    public static StockMarketLang stockmarket() {
        Langs.checkInitialized();
        return service.get(Langs.defaultLang(), "stockmarket.json", StockMarketLang.class);
    }

    public static UtilityLang utility() {
        Langs.checkInitialized();
        return service.get(Langs.defaultLang(), "utility.json", UtilityLang.class);
    }

    public static ServerRocketLang serverrocket() {
        Langs.checkInitialized();
        return service.get(Langs.defaultLang(), "serverrocket.json", ServerRocketLang.class);
    }

    private static void checkInitialized() {
        if (service == null) {
            throw new IllegalStateException("Langs not initialized! Call Langs.init(LangService) first.");
        }
    }
}

