/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.listener;

import ch.serverrocket.database.reports.ModerationDataService;
import ch.serverrocket.database.reports.ModerationHistoryData;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.event.events.player.PlayerChatEvent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import java.lang.reflect.Method;
import java.util.UUID;

public final class ChatListener {
    public static void onPlayerChat(PlayerChatEvent event) {
        PlayerRef playerRef = null;
        try {
            Method mGetPlayerRef = event.getClass().getMethod("getPlayerRef", new Class[0]);
            playerRef = (PlayerRef)mGetPlayerRef.invoke((Object)event, new Object[0]);
        }
        catch (Exception var7) {
            try {
                Method mGetPlayer = event.getClass().getMethod("getPlayer", new Class[0]);
                Object p = mGetPlayer.invoke((Object)event, new Object[0]);
                if (p instanceof PlayerRef) {
                    playerRef = (PlayerRef)p;
                }
            }
            catch (Exception mGetPlayer) {
                // empty catch block
            }
        }
        if (playerRef != null) {
            ChatListener.checkAndCancel(event, playerRef.getUuid(), playerRef);
        } else {
            try {
                Method mGetUuid = event.getClass().getMethod("getUuid", new Class[0]);
                UUID uuid = (UUID)mGetUuid.invoke((Object)event, new Object[0]);
                ChatListener.checkAndCancel(event, uuid, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void checkAndCancel(PlayerChatEvent event, UUID uuid, PlayerRef playerRef) {
        ModerationHistoryData activeMute = ModerationDataService.getActiveModeration(uuid, "MUTE");
        if (activeMute != null) {
            try {
                Method mSetCancelled = event.getClass().getMethod("setCancelled", Boolean.TYPE);
                mSetCancelled.invoke((Object)event, true);
            }
            catch (Exception var12) {
                try {
                    Method mSetCanceled = event.getClass().getMethod("setCanceled", Boolean.TYPE);
                    mSetCanceled.invoke((Object)event, true);
                }
                catch (Exception var11) {
                    try {
                        Method mCancel = event.getClass().getMethod("cancel", new Class[0]);
                        mCancel.invoke((Object)event, new Object[0]);
                    }
                    catch (Exception mCancel) {
                        // empty catch block
                    }
                }
            }
            if (playerRef != null) {
                Object expiryStr;
                String reason = activeMute.getCustomReason();
                if (activeMute.getExpiry() == null) {
                    expiryStr = "Permanent";
                } else {
                    long diffSeconds = activeMute.getExpiry() - System.currentTimeMillis() / 1000L;
                    long minutes = (diffSeconds + 59L) / 60L;
                    if (minutes < 0L) {
                        minutes = 0L;
                    }
                    expiryStr = minutes + " Minutes";
                }
                String message = String.format(Langs.minerva().moderationPlayerMuted(), reason, expiryStr);
                String var10001 = PrefixManager.minerva();
                playerRef.sendMessage(Message.raw((String)(var10001 + message)));
            }
        }
    }
}

