/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.listener;

import ch.serverrocket.database.friends.FriendDataService;
import ch.serverrocket.database.friends.Friendship;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.event.events.player.PlayerDisconnectEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerReadyEvent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class FriendListener {
    public static void onPlayerReady(PlayerReadyEvent event) {
        World world = event.getPlayer().getWorld();
        PlayerRef joiningPlayer = null;
        for (PlayerRef ref : world.getPlayerRefs()) {
            UUID playerUuid;
            UUID refUuid = ref.getUuid();
            if (!refUuid.equals(playerUuid = event.getPlayer().getUuid())) continue;
            joiningPlayer = ref;
            break;
        }
        if (joiningPlayer != null) {
            UUID uuid = joiningPlayer.getUuid();
            String name = joiningPlayer.getUsername();
            List<Friendship> friendships = FriendDataService.getFriends(uuid);
            Collection<PlayerRef> onlinePlayers = FriendListener.getOnlinePlayers(world);
            block1: for (Friendship f : friendships) {
                UUID friendUuid = f.getFriendOf(uuid);
                for (PlayerRef online : onlinePlayers) {
                    if (!online.getUuid().equals(friendUuid)) continue;
                    String var10001 = PrefixManager.serverrocket();
                    online.sendMessage(Message.raw((String)(var10001 + " " + String.format(Langs.minerva().friendOnline(), name))));
                    continue block1;
                }
            }
        }
    }

    public static void onPlayerDisconnect(PlayerDisconnectEvent event) {
        PlayerRef leavingPlayer = event.getPlayerRef();
        UUID uuid = leavingPlayer.getUuid();
        String name = leavingPlayer.getUsername();
        World world = null;
        try {
            Object worldObj = leavingPlayer.getClass().getMethod("getWorld", new Class[0]).invoke((Object)leavingPlayer, new Object[0]);
            if (worldObj instanceof World) {
                World worldRef;
                world = worldRef = (World)worldObj;
            }
        }
        catch (ReflectiveOperationException | RuntimeException worldObj) {
            // empty catch block
        }
        List<Friendship> friendships = FriendDataService.getFriends(uuid);
        Collection<PlayerRef> onlinePlayers = FriendListener.getOnlinePlayers(world);
        block2: for (Friendship f : friendships) {
            UUID friendUuid = f.getFriendOf(uuid);
            for (PlayerRef online : onlinePlayers) {
                if (!online.getUuid().equals(friendUuid)) continue;
                String var10001 = PrefixManager.serverrocket();
                online.sendMessage(Message.raw((String)(var10001 + " " + String.format(Langs.minerva().friendOffline(), name))));
                continue block2;
            }
        }
    }

    private static Collection<PlayerRef> getOnlinePlayers(World world) {
        if (world == null) {
            return FriendListener.getOnlinePlayersFromServer();
        }
        try {
            Object worldsObj;
            Object universe = FriendListener.tryGetUniverseFromWorld(world);
            if (universe != null && (worldsObj = FriendListener.tryGetWorldsMap(universe)) instanceof Map) {
                Map worlds = (Map)worldsObj;
                HashMap<UUID, PlayerRef> players = new HashMap<UUID, PlayerRef>();
                for (Object w : worlds.values()) {
                    if (!(w instanceof World)) continue;
                    World worldRef = (World)w;
                    for (PlayerRef ref : worldRef.getPlayerRefs()) {
                        players.put(ref.getUuid(), ref);
                    }
                }
                return new ArrayList<PlayerRef>(players.values());
            }
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            // empty catch block
        }
        return world.getPlayerRefs();
    }

    private static Collection<PlayerRef> getOnlinePlayersFromServer() {
        try {
            Object worldsObj;
            Object universe = FriendListener.tryGetUniverseFromServer();
            if (universe != null && (worldsObj = FriendListener.tryGetWorldsMap(universe)) instanceof Map) {
                Map worlds = (Map)worldsObj;
                HashMap<UUID, PlayerRef> players = new HashMap<UUID, PlayerRef>();
                for (Object w : worlds.values()) {
                    if (!(w instanceof World)) continue;
                    World worldRef = (World)w;
                    for (PlayerRef ref : worldRef.getPlayerRefs()) {
                        players.put(ref.getUuid(), ref);
                    }
                }
                return new ArrayList<PlayerRef>(players.values());
            }
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            // empty catch block
        }
        return new ArrayList<PlayerRef>();
    }

    private static Object tryGetUniverseFromWorld(World world) throws ReflectiveOperationException {
        try {
            return world.getClass().getMethod("getUniverse", new Class[0]).invoke((Object)world, new Object[0]);
        }
        catch (ReflectiveOperationException var3) {
            Class<?> serverClass = Class.forName("com.hypixel.hytale.server.core.HytaleServer");
            Object server = serverClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            return serverClass.getMethod("getUniverse", new Class[0]).invoke(server, new Object[0]);
        }
    }

    private static Object tryGetUniverseFromServer() throws ReflectiveOperationException {
        Class<?> serverClass = Class.forName("com.hypixel.hytale.server.core.HytaleServer");
        Object server = serverClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
        return serverClass.getMethod("getUniverse", new Class[0]).invoke(server, new Object[0]);
    }

    private static Object tryGetWorldsMap(Object universe) throws ReflectiveOperationException {
        try {
            return universe.getClass().getMethod("getWorlds", new Class[0]).invoke(universe, new Object[0]);
        }
        catch (ReflectiveOperationException var3) {
            try {
                Field field = universe.getClass().getDeclaredField("unmodifiableWorlds");
                field.setAccessible(true);
                return field.get(universe);
            }
            catch (ReflectiveOperationException var2) {
                Field field = universe.getClass().getDeclaredField("worlds");
                field.setAccessible(true);
                return field.get(universe);
            }
        }
    }
}

