/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.main;

import ch.serverrocket.config.ConfigManager;
import ch.serverrocket.config.ConfigService;
import ch.serverrocket.config.Configs;
import ch.serverrocket.config.configfiles.EconomyConfig;
import ch.serverrocket.config.configfiles.FriendsystemConfig;
import ch.serverrocket.config.configfiles.MinervaConfig;
import ch.serverrocket.config.configfiles.ModulesConfig;
import ch.serverrocket.config.configfiles.ServerRocketConfig;
import ch.serverrocket.config.configfiles.StockMarketConfig;
import ch.serverrocket.dashboard.DashboardCommand;
import ch.serverrocket.database.DatabaseManager;
import ch.serverrocket.database.reports.ServerRocketAccessProvider;
import ch.serverrocket.economy.EcoCommand;
import ch.serverrocket.economy.MoneyCommand;
import ch.serverrocket.economy.PayCommand;
import ch.serverrocket.friendsystem.FriendCommand;
import ch.serverrocket.lang.EconomyLang;
import ch.serverrocket.lang.LangService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.lang.MinervaLang;
import ch.serverrocket.lang.ServerRocketLang;
import ch.serverrocket.lang.StockMarketLang;
import ch.serverrocket.lang.UtilityLang;
import ch.serverrocket.listener.ChatListener;
import ch.serverrocket.listener.DutyListener;
import ch.serverrocket.listener.FriendListener;
import ch.serverrocket.listener.ModerationListener;
import ch.serverrocket.listener.PlayerDatabaseListener;
import ch.serverrocket.minerva.DutyCommand;
import ch.serverrocket.minerva.PlayerinfoCommand;
import ch.serverrocket.minerva.bansystem.BanCommand;
import ch.serverrocket.minerva.bansystem.ModReasonCommand;
import ch.serverrocket.minerva.bansystem.MuteCommand;
import ch.serverrocket.minerva.bansystem.PlayerhistoryCommand;
import ch.serverrocket.minerva.bansystem.UnbanCommand;
import ch.serverrocket.minerva.bansystem.UnmuteCommand;
import ch.serverrocket.minerva.bansystem.WarnCommand;
import ch.serverrocket.minerva.reportsystem.ReportCommand;
import ch.serverrocket.minerva.reportsystem.ReportGotoCommand;
import ch.serverrocket.minerva.reportsystem.ReportReasonCommand;
import ch.serverrocket.minerva.staffdashboard.StaffDashboardCommand;
import ch.serverrocket.stockmarket.StockMarketCommand;
import ch.serverrocket.utility.AfkCommand;
import ch.serverrocket.utility.BroadcastCommand;
import ch.serverrocket.utility.ClearCommand;
import ch.serverrocket.utility.FlyCommand;
import ch.serverrocket.utility.GodCommand;
import ch.serverrocket.utility.HealCommand;
import ch.serverrocket.utility.KillCommand;
import ch.serverrocket.utility.ListCommand;
import ch.serverrocket.utility.MsgCommand;
import ch.serverrocket.utility.NearCommand;
import ch.serverrocket.utility.RepairCommand;
import ch.serverrocket.utility.SocialSpyCommand;
import ch.serverrocket.utility.TeleportCommand;
import ch.serverrocket.utility.TopCommand;
import ch.serverrocket.utility.TpAcceptCommand;
import ch.serverrocket.utility.TpDenyCommand;
import ch.serverrocket.utility.TpaCommand;
import ch.serverrocket.utility.TpaHereCommand;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.event.events.player.PlayerChatEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerDisconnectEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerReadyEvent;
import com.hypixel.hytale.server.core.modules.accesscontrol.AccessControlModule;
import com.hypixel.hytale.server.core.modules.accesscontrol.provider.AccessProvider;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import java.io.File;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class Main
extends JavaPlugin {
    private static final HytaleLogger LOGGER = HytaleLogger.forEnclosingClass();
    private static Main instance;
    ConfigManager configManager = new ConfigManager();

    public Main(@Nonnull JavaPluginInit init) {
        super(init);
        instance = this;
    }

    public static Main getInstance() {
        return instance;
    }

    protected void setup() {
        LOGGER.at(Level.INFO).log("[ServerRocket] Setting up...");
        ConfigService configService = new ConfigService(this);
        configService.load("serverrocket.json", ServerRocketConfig.class);
        configService.load("modules.json", ModulesConfig.class);
        configService.load("minerva.json", MinervaConfig.class);
        configService.load("economy.json", EconomyConfig.class);
        configService.load("stockmarket.json", StockMarketConfig.class);
        configService.load("friendsystem.json", FriendsystemConfig.class);
        Configs.init(configService);
        File dataDir = Main.getInstance().getDataDirectory().toFile();
        DatabaseManager.init(dataDir, Configs.serverrocket().getDatabase());
        String language = Configs.serverrocket().getLanguage();
        LangService langService = new LangService(this);
        langService.load(language, "serverrocket.json", ServerRocketLang.class);
        langService.load(language, "minerva.json", MinervaLang.class);
        langService.load(language, "utility.json", UtilityLang.class);
        langService.load(language, "economy.json", EconomyLang.class);
        langService.load(language, "stockmarket.json", StockMarketLang.class);
        Langs.init(langService);
        ModulesConfig modules = Configs.modules();
        if (modules.minervaModuleIsActivated()) {
            this.getCommandRegistry().registerCommand((AbstractCommand)new PlayerinfoCommand());
            this.getCommandRegistry().registerCommand((AbstractCommand)new DutyCommand());
            this.getEventRegistry().registerGlobal(PlayerReadyEvent.class, PlayerDatabaseListener::onPlayerReady);
            this.getEventRegistry().registerGlobal(PlayerReadyEvent.class, DutyListener::onPlayerReady);
            this.getEventRegistry().registerGlobal(PlayerDisconnectEvent.class, PlayerDatabaseListener::onPlayerDisconnect);
            this.getEventRegistry().registerGlobal(PlayerDisconnectEvent.class, DutyListener::onPlayerDisconnect);
            if (modules.reportsystemIsActivated()) {
                this.getCommandRegistry().registerCommand((AbstractCommand)new ReportReasonCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new ReportCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new ReportGotoCommand());
            }
            if (modules.bansystemIsActivated()) {
                this.getCommandRegistry().registerCommand((AbstractCommand)new ModReasonCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new BanCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new UnbanCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new MuteCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new UnmuteCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new WarnCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new PlayerhistoryCommand());
                AccessControlModule.get().registerAccessProvider((AccessProvider)new ServerRocketAccessProvider());
                this.getEventRegistry().registerGlobal(PlayerReadyEvent.class, ModerationListener::onPlayerReady);
                this.getEventRegistry().registerGlobal(PlayerChatEvent.class, ChatListener::onPlayerChat);
            }
            if (modules.staffdashboardIsActivated()) {
                this.getCommandRegistry().registerCommand((AbstractCommand)new StaffDashboardCommand());
            }
            if (modules.dashboardIsActivated()) {
                this.getCommandRegistry().registerCommand((AbstractCommand)new DashboardCommand());
            }
            if (modules.friendsystemIsActivated()) {
                this.getCommandRegistry().registerCommand((AbstractCommand)new FriendCommand());
                this.getEventRegistry().registerGlobal(PlayerReadyEvent.class, FriendListener::onPlayerReady);
                this.getEventRegistry().registerGlobal(PlayerDisconnectEvent.class, FriendListener::onPlayerDisconnect);
            }
            if (modules.utilityIsActivated()) {
                this.getCommandRegistry().registerCommand((AbstractCommand)new TpaCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new TpaHereCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new TpAcceptCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new TpDenyCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new TeleportCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new FlyCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new GodCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new HealCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new KillCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new BroadcastCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new MsgCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new SocialSpyCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new ListCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new AfkCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new ClearCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new RepairCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new NearCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new TopCommand());
            }
            if (modules.economyIsActivated()) {
                this.getCommandRegistry().registerCommand((AbstractCommand)new MoneyCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new PayCommand());
                this.getCommandRegistry().registerCommand((AbstractCommand)new EcoCommand());
            }
            if (modules.stockmarketIsActivated()) {
                this.getCommandRegistry().registerCommand((AbstractCommand)new StockMarketCommand());
            }
        }
    }

    protected void start() {
        LOGGER.at(Level.INFO).log("[ServerRocket] Started!");
    }

    protected void shutdown() {
        LOGGER.at(Level.INFO).log("[ServerRocket] Shutting down...");
        DatabaseManager.shutdown();
        instance = null;
    }
}

