/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.minerva;

import ch.serverrocket.database.duty.DutyDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.MovementSettings;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.movement.MovementManager;
import com.hypixel.hytale.server.core.io.PacketHandler;
import com.hypixel.hytale.server.core.modules.entity.component.Invulnerable;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.UUID;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class DutyCommand
extends AbstractPlayerCommand {
    private final OptionalArg<String> modeArg = this.withOptionalArg("mode", "serverrocket.minerva.duty.mode", (ArgumentType)ArgTypes.STRING);

    public DutyCommand() {
        super("duty", "serverrocket.minerva.duty.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.minerva.duty")) {
            String var10 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var10 + " " + Langs.serverrocket().noPermission())));
        } else {
            UUID uuid = playerRef.getUuid();
            String mode = (String)this.modeArg.get(context);
            if (mode != null && "auto".equalsIgnoreCase(mode)) {
                boolean current = DutyDataService.isAutoDuty(uuid);
                DutyDataService.setAutoDuty(uuid, !current);
                if (!current) {
                    context.sendMessage(Message.raw((String)(PrefixManager.minerva() + "Auto-Duty enabled. You will now automatically go on duty when joining.")));
                } else {
                    context.sendMessage(Message.raw((String)(PrefixManager.minerva() + "Auto-Duty disabled.")));
                }
            } else if (DutyDataService.isOnDuty(uuid)) {
                DutyDataService.setDuty(uuid, false);
                store.removeComponent(ref, Invulnerable.getComponentType());
                DutyCommand.setFlying(ref, store, false);
                String var10001 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var10001 + Langs.minerva().offDuty())));
            } else {
                DutyDataService.setDuty(uuid, true);
                store.addComponent(ref, Invulnerable.getComponentType(), (Component)Invulnerable.INSTANCE);
                DutyCommand.setFlying(ref, store, true);
                String var9 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var9 + Langs.minerva().onDuty())));
            }
        }
    }

    public static void setFlying(Ref<EntityStore> ref, Store<EntityStore> store, boolean canFly) {
        MovementSettings settings;
        MovementManager movementManager = (MovementManager)store.getComponent(ref, MovementManager.getComponentType());
        if (movementManager != null && (settings = movementManager.getSettings()) != null) {
            PacketHandler connection;
            settings.canFly = canFly;
            Player player = (Player)store.getComponent(ref, Player.getComponentType());
            if (player != null && (connection = player.getPlayerConnection()) != null) {
                movementManager.update(connection);
            }
        }
    }
}

