/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.minerva;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.config.Configs;
import ch.serverrocket.database.duty.DutyDataService;
import ch.serverrocket.database.player.PlayerData;
import ch.serverrocket.database.player.PlayerDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class PlayerinfoCommand
extends AbstractPlayerCommand {
    private final RequiredArg<PlayerRef> targetArg = this.withRequiredArg("player", "serverrocket.minerva.playerinfo.target", (ArgumentType)ArgTypes.PLAYER_REF);

    public PlayerinfoCommand() {
        super("playerinfo", "serverrocket.minerva.playerinfo.desc");
        CommandUsage.addUsageVariant((AbstractCommand)this);
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.minerva.playerinfo")) {
            String var10 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var10 + " " + Langs.serverrocket().noPermission())));
        } else if (Configs.minerva().playerHasToBeOnDuty() && !DutyDataService.isOnDuty(playerRef.getUuid())) {
            String var9 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var9 + Langs.minerva().playerHasToBeOnDuty())));
        } else {
            PlayerRef targetPlayer = (PlayerRef)this.targetArg.get(context);
            PlayerData targetData = PlayerDataService.getByUUID(targetPlayer.getUuid());
            if (targetData == null) {
                String var10001 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var10001 + Langs.minerva().playerNotFound())));
            } else {
                StringBuilder info = new StringBuilder();
                info.append(Langs.minerva().playerinfoTitle());
                info.append(Langs.minerva().playerinfoUsername()).append(targetPlayer.getUsername()).append("\n");
                info.append(Langs.minerva().playerinfoUuid()).append(targetPlayer.getUuid()).append("\n");
                info.append(Langs.minerva().playerinfoFirstJoined()).append(PlayerData.formatDate(targetData.getFirstJoin())).append("\n");
                info.append(Langs.minerva().playerinfoLastSeen()).append(PlayerData.formatDate(targetData.getLastSeen())).append("\n");
                info.append(Langs.minerva().playerinfoPlaytime()).append(PlayerData.formatPlaytime(targetData.getPlaytime())).append("\n");
                context.sendMessage(Message.raw((String)info.toString()));
            }
        }
    }
}

