/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.minerva.bansystem;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.config.Configs;
import ch.serverrocket.database.duty.DutyDataService;
import ch.serverrocket.database.reports.ModerationDataService;
import ch.serverrocket.database.reports.ModerationReasonData;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.CommandBase;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;

public class MuteCommand
extends CommandBase {
    private final OptionalArg<PlayerRef> targetArg = this.withOptionalArg("player", "serverrocket.minerva.moderation.target", (ArgumentType)ArgTypes.PLAYER_REF);
    private final OptionalArg<String> reasonArg = this.withOptionalArg("reason", "serverrocket.minerva.moderation.reason", (ArgumentType)ArgTypes.STRING);

    public MuteCommand() {
        super("mute", "serverrocket.minerva.mute.desc");
    }

    protected void executeSync(@Nonnull CommandContext context) {
        if (!context.sender().hasPermission("serverrocket.minerva.mute")) {
            String var22 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var22 + " " + Langs.serverrocket().noPermission())));
        } else {
            UUID senderUuid = null;
            CommandSender var4 = context.sender();
            if (var4 instanceof PlayerRef) {
                PlayerRef playerRefSender = (PlayerRef)var4;
                senderUuid = playerRefSender.getUuid();
                if (Configs.minerva().playerHasToBeOnDuty() && !DutyDataService.isOnDuty(senderUuid)) {
                    String var10001 = PrefixManager.minerva();
                    context.sendMessage(Message.raw((String)(var10001 + Langs.minerva().playerHasToBeOnDuty())));
                    return;
                }
            } else {
                senderUuid = new UUID(0L, 0L);
            }
            if (CommandUsage.requireArgs(context, new Argument[]{this.targetArg, this.reasonArg})) {
                PlayerRef target = (PlayerRef)this.targetArg.get(context);
                String reasonInput = (String)this.reasonArg.get(context);
                boolean numeric = false;
                ModerationReasonData reason = null;
                try {
                    int index = Integer.parseInt(reasonInput);
                    numeric = true;
                    reason = ModerationDataService.getReasonByIndex("MUTE", index);
                }
                catch (NumberFormatException var13) {
                    reason = ModerationDataService.getReasonByName(reasonInput);
                }
                if (reason != null && "MUTE".equalsIgnoreCase(reason.getType())) {
                    Object expiryStr;
                    Long expiry = null;
                    if (reason.getDefaultDuration() != null && reason.getDefaultDuration() > 0) {
                        expiry = System.currentTimeMillis() / 1000L + (long)reason.getDefaultDuration().intValue();
                    }
                    ModerationDataService.recordModeration(target.getUuid(), senderUuid, "MUTE", reason.getId(), null, expiry);
                    if (expiry == null) {
                        expiryStr = "Permanent";
                    } else {
                        long diffSeconds = expiry - System.currentTimeMillis() / 1000L;
                        long minutes = (diffSeconds + 59L) / 60L;
                        expiryStr = minutes + " Minutes";
                    }
                    String var20 = PrefixManager.minerva();
                    target.sendMessage(Message.raw((String)(var20 + String.format(Langs.minerva().moderationPlayerMuted(), reason.getName(), expiryStr))));
                    var20 = PrefixManager.minerva();
                    context.sendMessage(Message.raw((String)(var20 + String.format(Langs.minerva().moderationActionSuccess(), "MUTE", target.getUsername()))));
                } else {
                    String var19 = PrefixManager.minerva();
                    context.sendMessage(Message.raw((String)(var19 + String.format(Langs.minerva().moderationIdNotFound(), reasonInput, "MUTE"))));
                    if (numeric) {
                        this.sendReasonList(context, "MUTE");
                    }
                }
            }
        }
    }

    private void sendReasonList(CommandContext context, String type) {
        List<ModerationReasonData> reasons = ModerationDataService.getReasonsByType(type);
        if (reasons.isEmpty()) {
            String var8 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var8 + "Es wurden noch keine Gr\u00fcnde f\u00fcr " + type + " konfiguriert.")));
        } else {
            String var10001 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var10001 + "Verf\u00fcgbare Gr\u00fcnde f\u00fcr " + type + ":")));
            for (int i = 0; i < reasons.size(); ++i) {
                ModerationReasonData r = reasons.get(i);
                String durationStr = r.getDefaultDuration() != null && r.getDefaultDuration() != 0 ? this.formatDuration(r.getDefaultDuration()) : "Permanent";
                context.sendMessage(Message.raw((String)("  " + (i + 1) + ". " + r.getName() + " [" + durationStr + "]")));
            }
            var10001 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var10001 + Langs.minerva().moderationMuteUsage())));
        }
    }

    private String formatDuration(int seconds) {
        if (seconds <= 0) {
            return "Permanent";
        }
        if (seconds % 31536000 == 0) {
            return seconds / 31536000 + " Years";
        }
        if (seconds % 2592000 == 0) {
            return seconds / 2592000 + " Months";
        }
        if (seconds % 604800 == 0) {
            return seconds / 604800 + " Weeks";
        }
        if (seconds % 86400 == 0) {
            return seconds / 86400 + " Days";
        }
        return seconds % 3600 == 0 ? seconds / 3600 + " Hours" : seconds / 60 + " Minutes";
    }
}

