/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.minerva.bansystem;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.database.player.PlayerData;
import ch.serverrocket.database.player.PlayerDataService;
import ch.serverrocket.database.reports.ModerationDataService;
import ch.serverrocket.database.reports.ModerationHistoryData;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class PlayerhistoryCommand
extends AbstractPlayerCommand {
    private final OptionalArg<String> targetNameArg = this.withOptionalArg("player", "serverrocket.minerva.moderation.target", (ArgumentType)ArgTypes.STRING);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");

    public PlayerhistoryCommand() {
        super("playerhistory", "serverrocket.minerva.history.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.minerva.history")) {
            String var18 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var18 + " " + Langs.serverrocket().noPermission())));
        } else if (CommandUsage.requireArgs(context, new Argument[]{this.targetNameArg})) {
            String targetName = (String)this.targetNameArg.get(context);
            PlayerData targetData = PlayerDataService.getByName(targetName);
            if (targetData == null) {
                String var17 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var17 + Langs.minerva().playerNotFound())));
            } else {
                UUID targetUuid = targetData.getUuid();
                List<ModerationHistoryData> history = ModerationDataService.getModerationHistory(targetUuid);
                if (history.isEmpty()) {
                    String var16 = PrefixManager.minerva();
                    context.sendMessage(Message.raw((String)(var16 + Langs.minerva().moderationHistoryEmpty())));
                } else {
                    String var10001 = PrefixManager.minerva();
                    context.sendMessage(Message.raw((String)(var10001 + String.format(Langs.minerva().moderationHistoryTitle(), targetData.getDisplayName()))));
                    for (ModerationHistoryData entry : history) {
                        String dateStr = this.dateFormat.format(new Date(entry.getTimestamp() * 1000L));
                        String staffName = this.getPlayerName(entry.getStaff());
                        String status = entry.isActive() ? (entry.isExpired() ? "[EXPIRED]" : "[ACTIVE]") : "[REVOKED]";
                        String entryMsg = String.format(Langs.minerva().moderationHistoryEntry(), dateStr, entry.getType(), entry.getCustomReason(), staffName, status);
                        context.sendMessage(Message.raw((String)("  " + entryMsg)));
                    }
                }
            }
        }
    }

    private String getPlayerName(UUID uuid) {
        PlayerData data = PlayerDataService.getByUUID(uuid);
        return data != null ? data.getDisplayName() : uuid.toString().substring(0, 8);
    }
}

